<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for textType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Text - will add basic formatting here
 * @subpackage Structs
 */
class TextType extends AbstractStructBase
{
    /**
     * The para
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - maxLength: 4000
     * @var string[]
     */
    public $para;
    /**
     * Constructor method for textType
     * @uses TextType::setPara()
     * @param string[] $para
     */
    public function __construct(array $para = array())
    {
        $this
            ->setPara($para);
    }
    /**
     * Get para value
     * @return string[]|null
     */
    public function getPara()
    {
        return $this->para;
    }
    /**
     * Set para value
     * @throws \InvalidArgumentException
     * @param string[] $para
     * @return \StructType\TextType
     */
    public function setPara(array $para = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($para) && strlen($para) > 4000) || (is_array($para) && count($para) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($para) ? strlen($para) : count($para)), __LINE__);
        }
        foreach ($para as $textTypeParaItem) {
            // validation for constraint: itemType
            if (!is_string($textTypeParaItem)) {
                throw new \InvalidArgumentException(sprintf('The para property can only contain items of string, "%s" given', is_object($textTypeParaItem) ? get_class($textTypeParaItem) : gettype($textTypeParaItem)), __LINE__);
            }
        }
        $this->para = $para;
        return $this;
    }
    /**
     * Add item to para value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TextType
     */
    public function addToPara($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 4000) || (is_array($item) && count($item) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The para property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->para[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TextType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
