<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for standardMessageHeaderType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Standard message header
 * @subpackage Structs
 */
class StandardMessageHeaderType extends AbstractStructBase
{
    /**
     * The messageType
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $messageType;
    /**
     * The messageVersion
     * Meta informations extracted from the WSDL
     * - maxLength: 4
     * @var string
     */
    public $messageVersion;
    /**
     * The originatingChannel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $originatingChannel;
    /**
     * The originatingService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $originatingService;
    /**
     * The transactionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $transactionId;
    /**
     * The operation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $operation;
    /**
     * Constructor method for standardMessageHeaderType
     * @uses StandardMessageHeaderType::setMessageType()
     * @uses StandardMessageHeaderType::setMessageVersion()
     * @uses StandardMessageHeaderType::setOriginatingChannel()
     * @uses StandardMessageHeaderType::setOriginatingService()
     * @uses StandardMessageHeaderType::setTransactionId()
     * @uses StandardMessageHeaderType::setOperation()
     * @param string $messageType
     * @param string $messageVersion
     * @param string $originatingChannel
     * @param string $originatingService
     * @param string $transactionId
     * @param string $operation
     */
    public function __construct($messageType = null, $messageVersion = null, $originatingChannel = null, $originatingService = null, $transactionId = null, $operation = null)
    {
        $this
            ->setMessageType($messageType)
            ->setMessageVersion($messageVersion)
            ->setOriginatingChannel($originatingChannel)
            ->setOriginatingService($originatingService)
            ->setTransactionId($transactionId)
            ->setOperation($operation);
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param string $messageType
     * @return \StructType\StandardMessageHeaderType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageType) && strlen($messageType) > 100) || (is_array($messageType) && count($messageType) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($messageType) ? strlen($messageType) : count($messageType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageType) && strlen($messageType) < 1) || (is_array($messageType) && count($messageType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get messageVersion value
     * @return string|null
     */
    public function getMessageVersion()
    {
        return $this->messageVersion;
    }
    /**
     * Set messageVersion value
     * @param string $messageVersion
     * @return \StructType\StandardMessageHeaderType
     */
    public function setMessageVersion($messageVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageVersion) && strlen($messageVersion) > 4) || (is_array($messageVersion) && count($messageVersion) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($messageVersion) ? strlen($messageVersion) : count($messageVersion)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageVersion) && !is_string($messageVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageVersion)), __LINE__);
        }
        $this->messageVersion = $messageVersion;
        return $this;
    }
    /**
     * Get originatingChannel value
     * @return string|null
     */
    public function getOriginatingChannel()
    {
        return $this->originatingChannel;
    }
    /**
     * Set originatingChannel value
     * @uses \EnumType\OriginatingChannelType::valueIsValid()
     * @uses \EnumType\OriginatingChannelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $originatingChannel
     * @return \StructType\StandardMessageHeaderType
     */
    public function setOriginatingChannel($originatingChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OriginatingChannelType::valueIsValid($originatingChannel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $originatingChannel, implode(', ', \EnumType\OriginatingChannelType::getValidValues())), __LINE__);
        }
        $this->originatingChannel = $originatingChannel;
        return $this;
    }
    /**
     * Get originatingService value
     * @return string|null
     */
    public function getOriginatingService()
    {
        return $this->originatingService;
    }
    /**
     * Set originatingService value
     * @uses \EnumType\OriginatingServiceType::valueIsValid()
     * @uses \EnumType\OriginatingServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $originatingService
     * @return \StructType\StandardMessageHeaderType
     */
    public function setOriginatingService($originatingService = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OriginatingServiceType::valueIsValid($originatingService)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $originatingService, implode(', ', \EnumType\OriginatingServiceType::getValidValues())), __LINE__);
        }
        $this->originatingService = $originatingService;
        return $this;
    }
    /**
     * Get transactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param string $transactionId
     * @return \StructType\StandardMessageHeaderType
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($transactionId) && strlen($transactionId) > 128) || (is_array($transactionId) && count($transactionId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($transactionId) ? strlen($transactionId) : count($transactionId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->operation;
    }
    /**
     * Set operation value
     * @param string $operation
     * @return \StructType\StandardMessageHeaderType
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($operation) && strlen($operation) > 50) || (is_array($operation) && count($operation) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($operation) ? strlen($operation) : count($operation)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operation)), __LINE__);
        }
        $this->operation = $operation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StandardMessageHeaderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
