<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for soapSoftwareIdentifierType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Identity for a SOAP message and software.
 * @subpackage Structs
 */
class SoapSoftwareIdentifierType extends AbstractStructBase
{
    /**
     * The externalReferenceNumber
     * Meta informations extracted from the WSDL
     * - documentation: Client provided to be unique within accountIdentifier
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $externalReferenceNumber;
    /**
     * The organisationalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Client provided identifier of client software version
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $organisationalName;
    /**
     * The productName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Client provided identifier of client software version
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $productName;
    /**
     * The productVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Client provided identifier of client software version
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $productVersion;
    /**
     * The asicSoftwareNo
     * Meta informations extracted from the WSDL
     * - documentation: ASIC issued identifier for client software | Internal Ascot Ids ie N9
     * - minOccurs: 0
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $asicSoftwareNo;
    /**
     * Constructor method for soapSoftwareIdentifierType
     * @uses SoapSoftwareIdentifierType::setExternalReferenceNumber()
     * @uses SoapSoftwareIdentifierType::setOrganisationalName()
     * @uses SoapSoftwareIdentifierType::setProductName()
     * @uses SoapSoftwareIdentifierType::setProductVersion()
     * @uses SoapSoftwareIdentifierType::setAsicSoftwareNo()
     * @param string $externalReferenceNumber
     * @param string $organisationalName
     * @param string $productName
     * @param string $productVersion
     * @param int $asicSoftwareNo
     */
    public function __construct($externalReferenceNumber = null, $organisationalName = null, $productName = null, $productVersion = null, $asicSoftwareNo = null)
    {
        $this
            ->setExternalReferenceNumber($externalReferenceNumber)
            ->setOrganisationalName($organisationalName)
            ->setProductName($productName)
            ->setProductVersion($productVersion)
            ->setAsicSoftwareNo($asicSoftwareNo);
    }
    /**
     * Get externalReferenceNumber value
     * @return string|null
     */
    public function getExternalReferenceNumber()
    {
        return $this->externalReferenceNumber;
    }
    /**
     * Set externalReferenceNumber value
     * @param string $externalReferenceNumber
     * @return \StructType\SoapSoftwareIdentifierType
     */
    public function setExternalReferenceNumber($externalReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalReferenceNumber) && strlen($externalReferenceNumber) > 50) || (is_array($externalReferenceNumber) && count($externalReferenceNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($externalReferenceNumber) ? strlen($externalReferenceNumber) : count($externalReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalReferenceNumber) && strlen($externalReferenceNumber) < 1) || (is_array($externalReferenceNumber) && count($externalReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalReferenceNumber) && !is_string($externalReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalReferenceNumber)), __LINE__);
        }
        $this->externalReferenceNumber = $externalReferenceNumber;
        return $this;
    }
    /**
     * Get organisationalName value
     * @return string|null
     */
    public function getOrganisationalName()
    {
        return $this->organisationalName;
    }
    /**
     * Set organisationalName value
     * @param string $organisationalName
     * @return \StructType\SoapSoftwareIdentifierType
     */
    public function setOrganisationalName($organisationalName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organisationalName) && strlen($organisationalName) > 100) || (is_array($organisationalName) && count($organisationalName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($organisationalName) ? strlen($organisationalName) : count($organisationalName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organisationalName) && strlen($organisationalName) < 1) || (is_array($organisationalName) && count($organisationalName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organisationalName) && !is_string($organisationalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationalName)), __LINE__);
        }
        $this->organisationalName = $organisationalName;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\SoapSoftwareIdentifierType
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productName) && strlen($productName) > 100) || (is_array($productName) && count($productName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($productName) ? strlen($productName) : count($productName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productName) && strlen($productName) < 1) || (is_array($productName) && count($productName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get productVersion value
     * @return string|null
     */
    public function getProductVersion()
    {
        return $this->productVersion;
    }
    /**
     * Set productVersion value
     * @param string $productVersion
     * @return \StructType\SoapSoftwareIdentifierType
     */
    public function setProductVersion($productVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productVersion) && strlen($productVersion) > 100) || (is_array($productVersion) && count($productVersion) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($productVersion) ? strlen($productVersion) : count($productVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productVersion) && strlen($productVersion) < 1) || (is_array($productVersion) && count($productVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productVersion) && !is_string($productVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productVersion)), __LINE__);
        }
        $this->productVersion = $productVersion;
        return $this;
    }
    /**
     * Get asicSoftwareNo value
     * @return int|null
     */
    public function getAsicSoftwareNo()
    {
        return $this->asicSoftwareNo;
    }
    /**
     * Set asicSoftwareNo value
     * @param int $asicSoftwareNo
     * @return \StructType\SoapSoftwareIdentifierType
     */
    public function setAsicSoftwareNo($asicSoftwareNo = null)
    {
        // validation for constraint: maxInclusive
        if ($asicSoftwareNo > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $asicSoftwareNo), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($asicSoftwareNo < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $asicSoftwareNo), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($asicSoftwareNo) && !is_numeric($asicSoftwareNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($asicSoftwareNo)), __LINE__);
        }
        $this->asicSoftwareNo = $asicSoftwareNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SoapSoftwareIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
