<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shareholders StructType
 * @subpackage Structs
 */
class Shareholders extends AbstractStructBase
{
    /**
     * The shareholder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ShareholderType[]
     */
    public $shareholder;
    /**
     * Constructor method for shareholders
     * @uses Shareholders::setShareholder()
     * @param \StructType\ShareholderType[] $shareholder
     */
    public function __construct(array $shareholder = array())
    {
        $this
            ->setShareholder($shareholder);
    }
    /**
     * Get shareholder value
     * @return \StructType\ShareholderType[]|null
     */
    public function getShareholder()
    {
        return $this->shareholder;
    }
    /**
     * Set shareholder value
     * @throws \InvalidArgumentException
     * @param \StructType\ShareholderType[] $shareholder
     * @return \StructType\Shareholders
     */
    public function setShareholder(array $shareholder = array())
    {
        foreach ($shareholder as $shareholdersShareholderItem) {
            // validation for constraint: itemType
            if (!$shareholdersShareholderItem instanceof \StructType\ShareholderType) {
                throw new \InvalidArgumentException(sprintf('The shareholder property can only contain items of \StructType\ShareholderType, "%s" given', is_object($shareholdersShareholderItem) ? get_class($shareholdersShareholderItem) : gettype($shareholdersShareholderItem)), __LINE__);
            }
        }
        $this->shareholder = $shareholder;
        return $this;
    }
    /**
     * Add item to shareholder value
     * @throws \InvalidArgumentException
     * @param \StructType\ShareholderType $item
     * @return \StructType\Shareholders
     */
    public function addToShareholder(\StructType\ShareholderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShareholderType) {
            throw new \InvalidArgumentException(sprintf('The shareholder property can only contain items of \StructType\ShareholderType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shareholder[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Shareholders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
