<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shareholderType StructType
 * @subpackage Structs
 */
class ShareholderType extends AbstractStructBase
{
    /**
     * The organisation
     * @var \StructType\OrganisationType
     */
    public $organisation;
    /**
     * The individual
     * @var \StructType\IndividualType
     */
    public $individual;
    /**
     * Constructor method for shareholderType
     * @uses ShareholderType::setOrganisation()
     * @uses ShareholderType::setIndividual()
     * @param \StructType\OrganisationType $organisation
     * @param \StructType\IndividualType $individual
     */
    public function __construct(\StructType\OrganisationType $organisation = null, \StructType\IndividualType $individual = null)
    {
        $this
            ->setOrganisation($organisation)
            ->setIndividual($individual);
    }
    /**
     * Get organisation value
     * @return \StructType\OrganisationType|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\OrganisationType $organisation
     * @return \StructType\ShareholderType
     */
    public function setOrganisation(\StructType\OrganisationType $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get individual value
     * @return \StructType\IndividualType|null
     */
    public function getIndividual()
    {
        return $this->individual;
    }
    /**
     * Set individual value
     * @param \StructType\IndividualType $individual
     * @return \StructType\ShareholderType
     */
    public function setIndividual(\StructType\IndividualType $individual = null)
    {
        $this->individual = $individual;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShareholderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
