<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for semiStructuredPhysicalAddress StructType
 * @subpackage Structs
 */
class SemiStructuredPhysicalAddress extends AbstractStructBase
{
    /**
     * The addressLine1
     * Meta informations extracted from the WSDL
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $addressLine1;
    /**
     * The addressLine2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $addressLine2;
    /**
     * The locality
     * Meta informations extracted from the WSDL
     * - documentation: LOV
     * @var string
     */
    public $locality;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - documentation: Enumeration: ACT, NSW, NT, QLD, SA, TAS, WA, VIC
     * @var string
     */
    public $state;
    /**
     * The postCode
     * Meta informations extracted from the WSDL
     * - maxLength: 12
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $postCode;
    /**
     * Constructor method for semiStructuredPhysicalAddress
     * @uses SemiStructuredPhysicalAddress::setAddressLine1()
     * @uses SemiStructuredPhysicalAddress::setAddressLine2()
     * @uses SemiStructuredPhysicalAddress::setLocality()
     * @uses SemiStructuredPhysicalAddress::setState()
     * @uses SemiStructuredPhysicalAddress::setPostCode()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $locality
     * @param string $state
     * @param string $postCode
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $locality = null, $state = null, $postCode = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setLocality($locality)
            ->setState($state)
            ->setPostCode($postCode);
    }
    /**
     * Get addressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->addressLine1;
    }
    /**
     * Set addressLine1 value
     * @param string $addressLine1
     * @return \StructType\SemiStructuredPhysicalAddress
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressLine1) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($addressLine1, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        $this->addressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get addressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->addressLine2;
    }
    /**
     * Set addressLine2 value
     * @param string $addressLine2
     * @return \StructType\SemiStructuredPhysicalAddress
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressLine2) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($addressLine2, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        $this->addressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get locality value
     * @return string|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @param string $locality
     * @return \StructType\SemiStructuredPhysicalAddress
     */
    public function setLocality($locality = null)
    {
        // validation for constraint: string
        if (!is_null($locality) && !is_string($locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locality)), __LINE__);
        }
        $this->locality = $locality;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\SemiStructuredPhysicalAddress
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \StructType\SemiStructuredPhysicalAddress
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postCode) && strlen($postCode) > 12) || (is_array($postCode) && count($postCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($postCode) ? strlen($postCode) : count($postCode)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($postCode) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($postCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SemiStructuredPhysicalAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
