<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchNniRequestType StructType
 * @subpackage Structs
 */
class SearchNniRequestType extends AbstractStructBase
{
    /**
     * The searchType
     * @var string
     */
    public $searchType;
    /**
     * The searchScope
     * Meta informations extracted from the WSDL
     * - length: 1
     * @var string
     */
    public $searchScope;
    /**
     * The organisation
     * @var \StructType\Organisation
     */
    public $organisation;
    /**
     * The maxResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxResult;
    /**
     * Constructor method for searchNniRequestType
     * @uses SearchNniRequestType::setSearchType()
     * @uses SearchNniRequestType::setSearchScope()
     * @uses SearchNniRequestType::setOrganisation()
     * @uses SearchNniRequestType::setMaxResult()
     * @param string $searchType
     * @param string $searchScope
     * @param \StructType\Organisation $organisation
     * @param int $maxResult
     */
    public function __construct($searchType = null, $searchScope = null, \StructType\Organisation $organisation = null, $maxResult = null)
    {
        $this
            ->setSearchType($searchType)
            ->setSearchScope($searchScope)
            ->setOrganisation($organisation)
            ->setMaxResult($maxResult);
    }
    /**
     * Get searchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->searchType;
    }
    /**
     * Set searchType value
     * @uses \EnumType\SearchType::valueIsValid()
     * @uses \EnumType\SearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\SearchNniRequestType
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchType::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType, implode(', ', \EnumType\SearchType::getValidValues())), __LINE__);
        }
        $this->searchType = $searchType;
        return $this;
    }
    /**
     * Get searchScope value
     * @return string|null
     */
    public function getSearchScope()
    {
        return $this->searchScope;
    }
    /**
     * Set searchScope value
     * @param string $searchScope
     * @return \StructType\SearchNniRequestType
     */
    public function setSearchScope($searchScope = null)
    {
        // validation for constraint: length
        if ((is_scalar($searchScope) && strlen($searchScope) !== 1) || (is_array($searchScope) && count($searchScope) !== 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($searchScope) && !is_string($searchScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchScope)), __LINE__);
        }
        $this->searchScope = $searchScope;
        return $this;
    }
    /**
     * Get organisation value
     * @return \StructType\Organisation|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\Organisation $organisation
     * @return \StructType\SearchNniRequestType
     */
    public function setOrganisation(\StructType\Organisation $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get maxResult value
     * @return int|null
     */
    public function getMaxResult()
    {
        return $this->maxResult;
    }
    /**
     * Set maxResult value
     * @param int $maxResult
     * @return \StructType\SearchNniRequestType
     */
    public function setMaxResult($maxResult = null)
    {
        // validation for constraint: int
        if (!is_null($maxResult) && !is_numeric($maxResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResult)), __LINE__);
        }
        $this->maxResult = $maxResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchNniRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
