<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reportRequestType StructType
 * @subpackage Structs
 */
class ReportRequestType extends AbstractStructBase
{
    /**
     * The reportType
     * @var string
     */
    public $reportType;
    /**
     * The reportPeriod
     * @var \StructType\PeriodType
     */
    public $reportPeriod;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * Constructor method for reportRequestType
     * @uses ReportRequestType::setReportType()
     * @uses ReportRequestType::setReportPeriod()
     * @uses ReportRequestType::setState()
     * @param string $reportType
     * @param \StructType\PeriodType $reportPeriod
     * @param string $state
     */
    public function __construct($reportType = null, \StructType\PeriodType $reportPeriod = null, $state = null)
    {
        $this
            ->setReportType($reportType)
            ->setReportPeriod($reportPeriod)
            ->setState($state);
    }
    /**
     * Get reportType value
     * @return string|null
     */
    public function getReportType()
    {
        return $this->reportType;
    }
    /**
     * Set reportType value
     * @uses \EnumType\BnReportType::valueIsValid()
     * @uses \EnumType\BnReportType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportType
     * @return \StructType\ReportRequestType
     */
    public function setReportType($reportType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BnReportType::valueIsValid($reportType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reportType, implode(', ', \EnumType\BnReportType::getValidValues())), __LINE__);
        }
        $this->reportType = $reportType;
        return $this;
    }
    /**
     * Get reportPeriod value
     * @return \StructType\PeriodType|null
     */
    public function getReportPeriod()
    {
        return $this->reportPeriod;
    }
    /**
     * Set reportPeriod value
     * @param \StructType\PeriodType $reportPeriod
     * @return \StructType\ReportRequestType
     */
    public function setReportPeriod(\StructType\PeriodType $reportPeriod = null)
    {
        $this->reportPeriod = $reportPeriod;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\ReportRequestType
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
