<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for replyType StructType
 * @subpackage Structs
 */
class ReplyType extends AbstractStructBase
{
    /**
     * The messageHeader
     * @var \StructType\StandardMessageHeaderType
     */
    public $messageHeader;
    /**
     * The messageIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageIdentifierType
     */
    public $messageIdentifier;
    /**
     * The result
     * @var \StructType\Result
     */
    public $result;
    /**
     * The exceptionList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExceptionListType
     */
    public $exceptionList;
    /**
     * The traceList
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * - minOccurs: 0
     * @var \StructType\TraceListType
     */
    public $traceList;
    /**
     * The timestampList
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * - minOccurs: 0
     * @var \StructType\TimestampListType
     */
    public $timestampList;
    /**
     * Constructor method for replyType
     * @uses ReplyType::setMessageHeader()
     * @uses ReplyType::setMessageIdentifier()
     * @uses ReplyType::setResult()
     * @uses ReplyType::setExceptionList()
     * @uses ReplyType::setTraceList()
     * @uses ReplyType::setTimestampList()
     * @param \StructType\StandardMessageHeaderType $messageHeader
     * @param \StructType\MessageIdentifierType $messageIdentifier
     * @param \StructType\Result $result
     * @param \StructType\ExceptionListType $exceptionList
     * @param \StructType\TraceListType $traceList
     * @param \StructType\TimestampListType $timestampList
     */
    public function __construct(\StructType\StandardMessageHeaderType $messageHeader = null, \StructType\MessageIdentifierType $messageIdentifier = null, \StructType\Result $result = null, \StructType\ExceptionListType $exceptionList = null, \StructType\TraceListType $traceList = null, \StructType\TimestampListType $timestampList = null)
    {
        $this
            ->setMessageHeader($messageHeader)
            ->setMessageIdentifier($messageIdentifier)
            ->setResult($result)
            ->setExceptionList($exceptionList)
            ->setTraceList($traceList)
            ->setTimestampList($timestampList);
    }
    /**
     * Get messageHeader value
     * @return \StructType\StandardMessageHeaderType|null
     */
    public function getMessageHeader()
    {
        return $this->messageHeader;
    }
    /**
     * Set messageHeader value
     * @param \StructType\StandardMessageHeaderType $messageHeader
     * @return \StructType\ReplyType
     */
    public function setMessageHeader(\StructType\StandardMessageHeaderType $messageHeader = null)
    {
        $this->messageHeader = $messageHeader;
        return $this;
    }
    /**
     * Get messageIdentifier value
     * @return \StructType\MessageIdentifierType|null
     */
    public function getMessageIdentifier()
    {
        return $this->messageIdentifier;
    }
    /**
     * Set messageIdentifier value
     * @param \StructType\MessageIdentifierType $messageIdentifier
     * @return \StructType\ReplyType
     */
    public function setMessageIdentifier(\StructType\MessageIdentifierType $messageIdentifier = null)
    {
        $this->messageIdentifier = $messageIdentifier;
        return $this;
    }
    /**
     * Get result value
     * @return \StructType\Result|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\Result $result
     * @return \StructType\ReplyType
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get exceptionList value
     * @return \StructType\ExceptionListType|null
     */
    public function getExceptionList()
    {
        return $this->exceptionList;
    }
    /**
     * Set exceptionList value
     * @param \StructType\ExceptionListType $exceptionList
     * @return \StructType\ReplyType
     */
    public function setExceptionList(\StructType\ExceptionListType $exceptionList = null)
    {
        $this->exceptionList = $exceptionList;
        return $this;
    }
    /**
     * Get traceList value
     * @return \StructType\TraceListType|null
     */
    public function getTraceList()
    {
        return $this->traceList;
    }
    /**
     * Set traceList value
     * @param \StructType\TraceListType $traceList
     * @return \StructType\ReplyType
     */
    public function setTraceList(\StructType\TraceListType $traceList = null)
    {
        $this->traceList = $traceList;
        return $this;
    }
    /**
     * Get timestampList value
     * @return \StructType\TimestampListType|null
     */
    public function getTimestampList()
    {
        return $this->timestampList;
    }
    /**
     * Set timestampList value
     * @param \StructType\TimestampListType $timestampList
     * @return \StructType\ReplyType
     */
    public function setTimestampList(\StructType\TimestampListType $timestampList = null)
    {
        $this->timestampList = $timestampList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReplyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
