<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for renewalResultType StructType
 * @subpackage Structs
 */
class RenewalResultType extends AbstractStructBase
{
    /**
     * The renewalTo
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $renewalTo;
    /**
     * The renewalFailed
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $renewalFailed;
    /**
     * Constructor method for renewalResultType
     * @uses RenewalResultType::setRenewalTo()
     * @uses RenewalResultType::setRenewalFailed()
     * @param string $renewalTo
     * @param bool $renewalFailed
     */
    public function __construct($renewalTo = null, $renewalFailed = null)
    {
        $this
            ->setRenewalTo($renewalTo)
            ->setRenewalFailed($renewalFailed);
    }
    /**
     * Get renewalTo value
     * @return string|null
     */
    public function getRenewalTo()
    {
        return $this->renewalTo;
    }
    /**
     * Set renewalTo value
     * @param string $renewalTo
     * @return \StructType\RenewalResultType
     */
    public function setRenewalTo($renewalTo = null)
    {
        // validation for constraint: minInclusive
        if ($renewalTo < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $renewalTo), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($renewalTo) && !is_string($renewalTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($renewalTo)), __LINE__);
        }
        $this->renewalTo = $renewalTo;
        return $this;
    }
    /**
     * Get renewalFailed value
     * @return bool|null
     */
    public function getRenewalFailed()
    {
        return $this->renewalFailed;
    }
    /**
     * Set renewalFailed value
     * @param bool $renewalFailed
     * @return \StructType\RenewalResultType
     */
    public function setRenewalFailed($renewalFailed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($renewalFailed) && !preg_match('/true/', $renewalFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($renewalFailed, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($renewalFailed) && !is_bool($renewalFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($renewalFailed)), __LINE__);
        }
        $this->renewalFailed = $renewalFailed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RenewalResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
