<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for renewalReplyDataType StructType
 * @subpackage Structs
 */
class RenewalReplyDataType extends AbstractStructBase
{
    /**
     * The bnNumber
     * Meta informations extracted from the WSDL
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $bnNumber;
    /**
     * The renewalResult
     * @var \StructType\RenewalResultType
     */
    public $renewalResult;
    /**
     * Constructor method for renewalReplyDataType
     * @uses RenewalReplyDataType::setBnNumber()
     * @uses RenewalReplyDataType::setRenewalResult()
     * @param int $bnNumber
     * @param \StructType\RenewalResultType $renewalResult
     */
    public function __construct($bnNumber = null, \StructType\RenewalResultType $renewalResult = null)
    {
        $this
            ->setBnNumber($bnNumber)
            ->setRenewalResult($renewalResult);
    }
    /**
     * Get bnNumber value
     * @return int|null
     */
    public function getBnNumber()
    {
        return $this->bnNumber;
    }
    /**
     * Set bnNumber value
     * @param int $bnNumber
     * @return \StructType\RenewalReplyDataType
     */
    public function setBnNumber($bnNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($bnNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $bnNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($bnNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $bnNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($bnNumber) && !is_numeric($bnNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bnNumber)), __LINE__);
        }
        $this->bnNumber = $bnNumber;
        return $this;
    }
    /**
     * Get renewalResult value
     * @return \StructType\RenewalResultType|null
     */
    public function getRenewalResult()
    {
        return $this->renewalResult;
    }
    /**
     * Set renewalResult value
     * @param \StructType\RenewalResultType $renewalResult
     * @return \StructType\RenewalReplyDataType
     */
    public function setRenewalResult(\StructType\RenewalResultType $renewalResult = null)
    {
        $this->renewalResult = $renewalResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RenewalReplyDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
