<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relationship StructType
 * Meta informations extracted from the WSDL
 * - documentation: The relationship allows for the definition of the position held by the associate.
 * @subpackage Structs
 */
class Relationship extends AbstractStructBase
{
    /**
     * The positionHeldCode
     * Meta informations extracted from the WSDL
     * - documentation: The positionHeldCode classifies the position held by a person or organisation into one of several categories.
     * - maxLength: 4
     * @var string
     */
    public $positionHeldCode;
    /**
     * The effectiveTo
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveTo date indicates the date from which this associate holding this position is no longer effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveTo;
    /**
     * The effectiveFrom
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveFrom date defines the date from which this associate holding this position becomes effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveFrom;
    /**
     * Constructor method for relationship
     * @uses Relationship::setPositionHeldCode()
     * @uses Relationship::setEffectiveTo()
     * @uses Relationship::setEffectiveFrom()
     * @param string $positionHeldCode
     * @param string $effectiveTo
     * @param string $effectiveFrom
     */
    public function __construct($positionHeldCode = null, $effectiveTo = null, $effectiveFrom = null)
    {
        $this
            ->setPositionHeldCode($positionHeldCode)
            ->setEffectiveTo($effectiveTo)
            ->setEffectiveFrom($effectiveFrom);
    }
    /**
     * Get positionHeldCode value
     * @return string|null
     */
    public function getPositionHeldCode()
    {
        return $this->positionHeldCode;
    }
    /**
     * Set positionHeldCode value
     * @param string $positionHeldCode
     * @return \StructType\Relationship
     */
    public function setPositionHeldCode($positionHeldCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($positionHeldCode) && strlen($positionHeldCode) > 4) || (is_array($positionHeldCode) && count($positionHeldCode) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($positionHeldCode) ? strlen($positionHeldCode) : count($positionHeldCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($positionHeldCode) && !is_string($positionHeldCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($positionHeldCode)), __LINE__);
        }
        $this->positionHeldCode = $positionHeldCode;
        return $this;
    }
    /**
     * Get effectiveTo value
     * @return string|null
     */
    public function getEffectiveTo()
    {
        return $this->effectiveTo;
    }
    /**
     * Set effectiveTo value
     * @param string $effectiveTo
     * @return \StructType\Relationship
     */
    public function setEffectiveTo($effectiveTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveTo) && !is_string($effectiveTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveTo)), __LINE__);
        }
        $this->effectiveTo = $effectiveTo;
        return $this;
    }
    /**
     * Get effectiveFrom value
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return $this->effectiveFrom;
    }
    /**
     * Set effectiveFrom value
     * @param string $effectiveFrom
     * @return \StructType\Relationship
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveFrom)), __LINE__);
        }
        $this->effectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Relationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
