<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rejectedType StructType
 * @subpackage Structs
 */
class RejectedType extends AbstractStructBase
{
    /**
     * The rejected
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $rejected;
    /**
     * Constructor method for rejectedType
     * @uses RejectedType::setRejected()
     * @param bool $rejected
     */
    public function __construct($rejected = null)
    {
        $this
            ->setRejected($rejected);
    }
    /**
     * Get rejected value
     * @return bool|null
     */
    public function getRejected()
    {
        return $this->rejected;
    }
    /**
     * Set rejected value
     * @param bool $rejected
     * @return \StructType\RejectedType
     */
    public function setRejected($rejected = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rejected) && !preg_match('/true/', $rejected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($rejected, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($rejected) && !is_bool($rejected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rejected)), __LINE__);
        }
        $this->rejected = $rejected;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RejectedType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
