<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for registrationRecord StructType
 * @subpackage Structs
 */
class RegistrationRecord extends AbstractStructBase
{
    /**
     * The bnReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $bnReferenceNumber;
    /**
     * The nniNumber
     * Meta informations extracted from the WSDL
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $nniNumber;
    /**
     * Constructor method for registrationRecord
     * @uses RegistrationRecord::setBnReferenceNumber()
     * @uses RegistrationRecord::setNniNumber()
     * @param int $bnReferenceNumber
     * @param int $nniNumber
     */
    public function __construct($bnReferenceNumber = null, $nniNumber = null)
    {
        $this
            ->setBnReferenceNumber($bnReferenceNumber)
            ->setNniNumber($nniNumber);
    }
    /**
     * Get bnReferenceNumber value
     * @return int|null
     */
    public function getBnReferenceNumber()
    {
        return $this->bnReferenceNumber;
    }
    /**
     * Set bnReferenceNumber value
     * @param int $bnReferenceNumber
     * @return \StructType\RegistrationRecord
     */
    public function setBnReferenceNumber($bnReferenceNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($bnReferenceNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $bnReferenceNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($bnReferenceNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $bnReferenceNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($bnReferenceNumber) && !is_numeric($bnReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bnReferenceNumber)), __LINE__);
        }
        $this->bnReferenceNumber = $bnReferenceNumber;
        return $this;
    }
    /**
     * Get nniNumber value
     * @return int|null
     */
    public function getNniNumber()
    {
        return $this->nniNumber;
    }
    /**
     * Set nniNumber value
     * @param int $nniNumber
     * @return \StructType\RegistrationRecord
     */
    public function setNniNumber($nniNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($nniNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $nniNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($nniNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $nniNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($nniNumber) && !is_numeric($nniNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nniNumber)), __LINE__);
        }
        $this->nniNumber = $nniNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegistrationRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
