<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for receiptType StructType
 * @subpackage Structs
 */
class ReceiptType extends AbstractStructBase
{
    /**
     * The debtor
     * @var \StructType\DebtorType
     */
    public $debtor;
    /**
     * The dateIssued
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateIssued;
    /**
     * The transaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\TransactionType[]
     */
    public $transaction;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $total;
    /**
     * The totalDue
     * Meta informations extracted from the WSDL
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $totalDue;
    /**
     * The dateDue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateDue;
    /**
     * The asicPaymentDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AsicPaymentDetailsType
     */
    public $asicPaymentDetails;
    /**
     * Constructor method for receiptType
     * @uses ReceiptType::setDebtor()
     * @uses ReceiptType::setDateIssued()
     * @uses ReceiptType::setTransaction()
     * @uses ReceiptType::setTotal()
     * @uses ReceiptType::setTotalDue()
     * @uses ReceiptType::setDateDue()
     * @uses ReceiptType::setAsicPaymentDetails()
     * @param \StructType\DebtorType $debtor
     * @param string $dateIssued
     * @param \StructType\TransactionType[] $transaction
     * @param float $total
     * @param float $totalDue
     * @param string $dateDue
     * @param \StructType\AsicPaymentDetailsType $asicPaymentDetails
     */
    public function __construct(\StructType\DebtorType $debtor = null, $dateIssued = null, array $transaction = array(), $total = null, $totalDue = null, $dateDue = null, \StructType\AsicPaymentDetailsType $asicPaymentDetails = null)
    {
        $this
            ->setDebtor($debtor)
            ->setDateIssued($dateIssued)
            ->setTransaction($transaction)
            ->setTotal($total)
            ->setTotalDue($totalDue)
            ->setDateDue($dateDue)
            ->setAsicPaymentDetails($asicPaymentDetails);
    }
    /**
     * Get debtor value
     * @return \StructType\DebtorType|null
     */
    public function getDebtor()
    {
        return $this->debtor;
    }
    /**
     * Set debtor value
     * @param \StructType\DebtorType $debtor
     * @return \StructType\ReceiptType
     */
    public function setDebtor(\StructType\DebtorType $debtor = null)
    {
        $this->debtor = $debtor;
        return $this;
    }
    /**
     * Get dateIssued value
     * @return string|null
     */
    public function getDateIssued()
    {
        return $this->dateIssued;
    }
    /**
     * Set dateIssued value
     * @param string $dateIssued
     * @return \StructType\ReceiptType
     */
    public function setDateIssued($dateIssued = null)
    {
        // validation for constraint: minInclusive
        if ($dateIssued < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateIssued), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateIssued) && !is_string($dateIssued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateIssued)), __LINE__);
        }
        $this->dateIssued = $dateIssued;
        return $this;
    }
    /**
     * Get transaction value
     * @return \StructType\TransactionType[]|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionType[] $transaction
     * @return \StructType\ReceiptType
     */
    public function setTransaction(array $transaction = array())
    {
        foreach ($transaction as $receiptTypeTransactionItem) {
            // validation for constraint: itemType
            if (!$receiptTypeTransactionItem instanceof \StructType\TransactionType) {
                throw new \InvalidArgumentException(sprintf('The transaction property can only contain items of \StructType\TransactionType, "%s" given', is_object($receiptTypeTransactionItem) ? get_class($receiptTypeTransactionItem) : gettype($receiptTypeTransactionItem)), __LINE__);
            }
        }
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Add item to transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionType $item
     * @return \StructType\ReceiptType
     */
    public function addToTransaction(\StructType\TransactionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionType) {
            throw new \InvalidArgumentException(sprintf('The transaction property can only contain items of \StructType\TransactionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->transaction[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\ReceiptType
     */
    public function setTotal($total = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($total) && strlen(substr($total, strpos($total, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($total, strpos($total, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($total > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $total), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($total < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $total), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get totalDue value
     * @return float|null
     */
    public function getTotalDue()
    {
        return $this->totalDue;
    }
    /**
     * Set totalDue value
     * @param float $totalDue
     * @return \StructType\ReceiptType
     */
    public function setTotalDue($totalDue = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($totalDue) && strlen(substr($totalDue, strpos($totalDue, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($totalDue, strpos($totalDue, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($totalDue > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $totalDue), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($totalDue < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $totalDue), __LINE__);
        }
        $this->totalDue = $totalDue;
        return $this;
    }
    /**
     * Get dateDue value
     * @return string|null
     */
    public function getDateDue()
    {
        return $this->dateDue;
    }
    /**
     * Set dateDue value
     * @param string $dateDue
     * @return \StructType\ReceiptType
     */
    public function setDateDue($dateDue = null)
    {
        // validation for constraint: minInclusive
        if ($dateDue < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateDue), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDue) && !is_string($dateDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDue)), __LINE__);
        }
        $this->dateDue = $dateDue;
        return $this;
    }
    /**
     * Get asicPaymentDetails value
     * @return \StructType\AsicPaymentDetailsType|null
     */
    public function getAsicPaymentDetails()
    {
        return $this->asicPaymentDetails;
    }
    /**
     * Set asicPaymentDetails value
     * @param \StructType\AsicPaymentDetailsType $asicPaymentDetails
     * @return \StructType\ReceiptType
     */
    public function setAsicPaymentDetails(\StructType\AsicPaymentDetailsType $asicPaymentDetails = null)
    {
        $this->asicPaymentDetails = $asicPaymentDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReceiptType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
