<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for physicalAddress StructType
 * @subpackage Structs
 */
class PhysicalAddress extends AbstractStructBase
{
    /**
     * The floorNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: The floor or level number in a building
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $floorNumber;
    /**
     * The propertyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: property or building name of the address
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $propertyName;
    /**
     * The unitOrOfficeNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: The unit or office number
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $unitOrOfficeNumber;
    /**
     * The streetNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $streetNumber;
    /**
     * The streetName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $streetName;
    /**
     * The streetType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: LOV
     * @var string
     */
    public $streetType;
    /**
     * The postalDeliveryType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Enumeration: CARE PO,CMA,CMB,GPO BOX,LOCKED BAG,MS,PO BOX,PRIVATE BAG,RSD,RMB,RMS,CPA
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $postalDeliveryType;
    /**
     * The postalDeliveryNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $postalDeliveryNumber;
    /**
     * The locality
     * Meta informations extracted from the WSDL
     * - documentation: LOV
     * @var string
     */
    public $locality;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - documentation: Enumeration: ACT, NSW, NT, QLD, SA, TAS, WA, VIC
     * @var string
     */
    public $state;
    /**
     * The postCode
     * Meta informations extracted from the WSDL
     * - maxLength: 12
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $postCode;
    /**
     * Constructor method for physicalAddress
     * @uses PhysicalAddress::setFloorNumber()
     * @uses PhysicalAddress::setPropertyName()
     * @uses PhysicalAddress::setUnitOrOfficeNumber()
     * @uses PhysicalAddress::setStreetNumber()
     * @uses PhysicalAddress::setStreetName()
     * @uses PhysicalAddress::setStreetType()
     * @uses PhysicalAddress::setPostalDeliveryType()
     * @uses PhysicalAddress::setPostalDeliveryNumber()
     * @uses PhysicalAddress::setLocality()
     * @uses PhysicalAddress::setState()
     * @uses PhysicalAddress::setPostCode()
     * @param string $floorNumber
     * @param string $propertyName
     * @param string $unitOrOfficeNumber
     * @param string $streetNumber
     * @param string $streetName
     * @param string $streetType
     * @param string $postalDeliveryType
     * @param string $postalDeliveryNumber
     * @param string $locality
     * @param string $state
     * @param string $postCode
     */
    public function __construct($floorNumber = null, $propertyName = null, $unitOrOfficeNumber = null, $streetNumber = null, $streetName = null, $streetType = null, $postalDeliveryType = null, $postalDeliveryNumber = null, $locality = null, $state = null, $postCode = null)
    {
        $this
            ->setFloorNumber($floorNumber)
            ->setPropertyName($propertyName)
            ->setUnitOrOfficeNumber($unitOrOfficeNumber)
            ->setStreetNumber($streetNumber)
            ->setStreetName($streetName)
            ->setStreetType($streetType)
            ->setPostalDeliveryType($postalDeliveryType)
            ->setPostalDeliveryNumber($postalDeliveryNumber)
            ->setLocality($locality)
            ->setState($state)
            ->setPostCode($postCode);
    }
    /**
     * Get floorNumber value
     * @return string|null
     */
    public function getFloorNumber()
    {
        return $this->floorNumber;
    }
    /**
     * Set floorNumber value
     * @param string $floorNumber
     * @return \StructType\PhysicalAddress
     */
    public function setFloorNumber($floorNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($floorNumber) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $floorNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($floorNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($floorNumber) && !is_string($floorNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floorNumber)), __LINE__);
        }
        $this->floorNumber = $floorNumber;
        return $this;
    }
    /**
     * Get propertyName value
     * @return string|null
     */
    public function getPropertyName()
    {
        return $this->propertyName;
    }
    /**
     * Set propertyName value
     * @param string $propertyName
     * @return \StructType\PhysicalAddress
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: pattern
        if (is_scalar($propertyName) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($propertyName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyName)), __LINE__);
        }
        $this->propertyName = $propertyName;
        return $this;
    }
    /**
     * Get unitOrOfficeNumber value
     * @return string|null
     */
    public function getUnitOrOfficeNumber()
    {
        return $this->unitOrOfficeNumber;
    }
    /**
     * Set unitOrOfficeNumber value
     * @param string $unitOrOfficeNumber
     * @return \StructType\PhysicalAddress
     */
    public function setUnitOrOfficeNumber($unitOrOfficeNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unitOrOfficeNumber) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $unitOrOfficeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($unitOrOfficeNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unitOrOfficeNumber) && !is_string($unitOrOfficeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOrOfficeNumber)), __LINE__);
        }
        $this->unitOrOfficeNumber = $unitOrOfficeNumber;
        return $this;
    }
    /**
     * Get streetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }
    /**
     * Set streetNumber value
     * @param string $streetNumber
     * @return \StructType\PhysicalAddress
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($streetNumber) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($streetNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetNumber)), __LINE__);
        }
        $this->streetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get streetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->streetName;
    }
    /**
     * Set streetName value
     * @param string $streetName
     * @return \StructType\PhysicalAddress
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: pattern
        if (is_scalar($streetName) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($streetName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        $this->streetName = $streetName;
        return $this;
    }
    /**
     * Get streetType value
     * @return string|null
     */
    public function getStreetType()
    {
        return $this->streetType;
    }
    /**
     * Set streetType value
     * @param string $streetType
     * @return \StructType\PhysicalAddress
     */
    public function setStreetType($streetType = null)
    {
        // validation for constraint: string
        if (!is_null($streetType) && !is_string($streetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetType)), __LINE__);
        }
        $this->streetType = $streetType;
        return $this;
    }
    /**
     * Get postalDeliveryType value
     * @return string|null
     */
    public function getPostalDeliveryType()
    {
        return $this->postalDeliveryType;
    }
    /**
     * Set postalDeliveryType value
     * @param string $postalDeliveryType
     * @return \StructType\PhysicalAddress
     */
    public function setPostalDeliveryType($postalDeliveryType = null)
    {
        // validation for constraint: pattern
        if (is_scalar($postalDeliveryType) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $postalDeliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($postalDeliveryType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postalDeliveryType) && !is_string($postalDeliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalDeliveryType)), __LINE__);
        }
        $this->postalDeliveryType = $postalDeliveryType;
        return $this;
    }
    /**
     * Get postalDeliveryNumber value
     * @return string|null
     */
    public function getPostalDeliveryNumber()
    {
        return $this->postalDeliveryNumber;
    }
    /**
     * Set postalDeliveryNumber value
     * @param string $postalDeliveryNumber
     * @return \StructType\PhysicalAddress
     */
    public function setPostalDeliveryNumber($postalDeliveryNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($postalDeliveryNumber) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $postalDeliveryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($postalDeliveryNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postalDeliveryNumber) && !is_string($postalDeliveryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalDeliveryNumber)), __LINE__);
        }
        $this->postalDeliveryNumber = $postalDeliveryNumber;
        return $this;
    }
    /**
     * Get locality value
     * @return string|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @param string $locality
     * @return \StructType\PhysicalAddress
     */
    public function setLocality($locality = null)
    {
        // validation for constraint: string
        if (!is_null($locality) && !is_string($locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locality)), __LINE__);
        }
        $this->locality = $locality;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\PhysicalAddress
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \StructType\PhysicalAddress
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postCode) && strlen($postCode) > 12) || (is_array($postCode) && count($postCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($postCode) ? strlen($postCode) : count($postCode)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($postCode) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($postCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PhysicalAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
