<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personWithRolesType StructType
 * @subpackage Structs
 */
class PersonWithRolesType extends PersonNameBirthType
{
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 5
     * - minLength: 3
     * @var string[]
     */
    public $role;
    /**
     * Constructor method for personWithRolesType
     * @uses PersonWithRolesType::setRole()
     * @param string[] $role
     */
    public function __construct(array $role = array())
    {
        $this
            ->setRole($role);
    }
    /**
     * Get role value
     * @return string[]|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @throws \InvalidArgumentException
     * @param string[] $role
     * @return \StructType\PersonWithRolesType
     */
    public function setRole(array $role = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($role) && strlen($role) > 5) || (is_array($role) && count($role) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($role) ? strlen($role) : count($role)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($role) && strlen($role) < 3) || (is_array($role) && count($role) < 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at least', __LINE__);
        }
        foreach ($role as $personWithRolesTypeRoleItem) {
            // validation for constraint: itemType
            if (!is_string($personWithRolesTypeRoleItem)) {
                throw new \InvalidArgumentException(sprintf('The role property can only contain items of string, "%s" given', is_object($personWithRolesTypeRoleItem) ? get_class($personWithRolesTypeRoleItem) : gettype($personWithRolesTypeRoleItem)), __LINE__);
            }
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Add item to role value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonWithRolesType
     */
    public function addToRole($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 5) || (is_array($item) && count($item) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 3) || (is_array($item) && count($item) < 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The role property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->role[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonWithRolesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
