<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personNameOptionalType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Personal name with optional givenName and familyName
 * @subpackage Structs
 */
class PersonNameOptionalType extends AbstractStructBase
{
    /**
     * The givenNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 140
     * - minLength: 1
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * - whiteSpace: collapse
     * @var string
     */
    public $givenNames;
    /**
     * The otherGivenNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 140
     * - minLength: 1
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * - whiteSpace: collapse
     * @var string
     */
    public $otherGivenNames;
    /**
     * The familyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 40
     * - minLength: 2
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * - whiteSpace: collapse
     * @var string
     */
    public $familyName;
    /**
     * Constructor method for personNameOptionalType
     * @uses PersonNameOptionalType::setGivenNames()
     * @uses PersonNameOptionalType::setOtherGivenNames()
     * @uses PersonNameOptionalType::setFamilyName()
     * @param string $givenNames
     * @param string $otherGivenNames
     * @param string $familyName
     */
    public function __construct($givenNames = null, $otherGivenNames = null, $familyName = null)
    {
        $this
            ->setGivenNames($givenNames)
            ->setOtherGivenNames($otherGivenNames)
            ->setFamilyName($familyName);
    }
    /**
     * Get givenNames value
     * @return string|null
     */
    public function getGivenNames()
    {
        return $this->givenNames;
    }
    /**
     * Set givenNames value
     * @param string $givenNames
     * @return \StructType\PersonNameOptionalType
     */
    public function setGivenNames($givenNames = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($givenNames) && strlen($givenNames) > 140) || (is_array($givenNames) && count($givenNames) > 140)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 140 element(s) or a scalar of 140 character(s) at most, "%d" length given', is_scalar($givenNames) ? strlen($givenNames) : count($givenNames)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($givenNames) && strlen($givenNames) < 1) || (is_array($givenNames) && count($givenNames) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($givenNames) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $givenNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($givenNames, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($givenNames) && !is_string($givenNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($givenNames)), __LINE__);
        }
        $this->givenNames = $givenNames;
        return $this;
    }
    /**
     * Get otherGivenNames value
     * @return string|null
     */
    public function getOtherGivenNames()
    {
        return $this->otherGivenNames;
    }
    /**
     * Set otherGivenNames value
     * @param string $otherGivenNames
     * @return \StructType\PersonNameOptionalType
     */
    public function setOtherGivenNames($otherGivenNames = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($otherGivenNames) && strlen($otherGivenNames) > 140) || (is_array($otherGivenNames) && count($otherGivenNames) > 140)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 140 element(s) or a scalar of 140 character(s) at most, "%d" length given', is_scalar($otherGivenNames) ? strlen($otherGivenNames) : count($otherGivenNames)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($otherGivenNames) && strlen($otherGivenNames) < 1) || (is_array($otherGivenNames) && count($otherGivenNames) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($otherGivenNames) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $otherGivenNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($otherGivenNames, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($otherGivenNames) && !is_string($otherGivenNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherGivenNames)), __LINE__);
        }
        $this->otherGivenNames = $otherGivenNames;
        return $this;
    }
    /**
     * Get familyName value
     * @return string|null
     */
    public function getFamilyName()
    {
        return $this->familyName;
    }
    /**
     * Set familyName value
     * @param string $familyName
     * @return \StructType\PersonNameOptionalType
     */
    public function setFamilyName($familyName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($familyName) && strlen($familyName) > 40) || (is_array($familyName) && count($familyName) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($familyName) ? strlen($familyName) : count($familyName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($familyName) && strlen($familyName) < 2) || (is_array($familyName) && count($familyName) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($familyName) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $familyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($familyName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($familyName) && !is_string($familyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($familyName)), __LINE__);
        }
        $this->familyName = $familyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonNameOptionalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
