<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personNameFormerNameType StructType
 * @subpackage Structs
 */
class PersonNameFormerNameType extends AbstractStructBase
{
    /**
     * The personId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $personId;
    /**
     * The name
     * @var \StructType\PersonNameType
     */
    public $name;
    /**
     * The formerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\PersonNameType[]
     */
    public $formerName;
    /**
     * Constructor method for personNameFormerNameType
     * @uses PersonNameFormerNameType::setPersonId()
     * @uses PersonNameFormerNameType::setName()
     * @uses PersonNameFormerNameType::setFormerName()
     * @param string $personId
     * @param \StructType\PersonNameType $name
     * @param \StructType\PersonNameType[] $formerName
     */
    public function __construct($personId = null, \StructType\PersonNameType $name = null, array $formerName = array())
    {
        $this
            ->setPersonId($personId)
            ->setName($name)
            ->setFormerName($formerName);
    }
    /**
     * Get personId value
     * @return string|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param string $personId
     * @return \StructType\PersonNameFormerNameType
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: string
        if (!is_null($personId) && !is_string($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\PersonNameFormerNameType
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get formerName value
     * @return \StructType\PersonNameType[]|null
     */
    public function getFormerName()
    {
        return $this->formerName;
    }
    /**
     * Set formerName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType[] $formerName
     * @return \StructType\PersonNameFormerNameType
     */
    public function setFormerName(array $formerName = array())
    {
        foreach ($formerName as $personNameFormerNameTypeFormerNameItem) {
            // validation for constraint: itemType
            if (!$personNameFormerNameTypeFormerNameItem instanceof \StructType\PersonNameType) {
                throw new \InvalidArgumentException(sprintf('The formerName property can only contain items of \StructType\PersonNameType, "%s" given', is_object($personNameFormerNameTypeFormerNameItem) ? get_class($personNameFormerNameTypeFormerNameItem) : gettype($personNameFormerNameTypeFormerNameItem)), __LINE__);
            }
        }
        $this->formerName = $formerName;
        return $this;
    }
    /**
     * Add item to formerName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType $item
     * @return \StructType\PersonNameFormerNameType
     */
    public function addToFormerName(\StructType\PersonNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonNameType) {
            throw new \InvalidArgumentException(sprintf('The formerName property can only contain items of \StructType\PersonNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->formerName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonNameFormerNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
