<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personNameBirthType StructType
 * @subpackage Structs
 */
class PersonNameBirthType extends AbstractStructBase
{
    /**
     * The personId
     * @var string
     */
    public $personId;
    /**
     * The name
     * @var \StructType\PersonNameType
     */
    public $name;
    /**
     * The formerName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $formerName;
    /**
     * The birthDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BirthDetailsType
     */
    public $birthDetails;
    /**
     * Constructor method for personNameBirthType
     * @uses PersonNameBirthType::setPersonId()
     * @uses PersonNameBirthType::setName()
     * @uses PersonNameBirthType::setFormerName()
     * @uses PersonNameBirthType::setBirthDetails()
     * @param string $personId
     * @param \StructType\PersonNameType $name
     * @param \StructType\PersonNameType $formerName
     * @param \StructType\BirthDetailsType $birthDetails
     */
    public function __construct($personId = null, \StructType\PersonNameType $name = null, \StructType\PersonNameType $formerName = null, \StructType\BirthDetailsType $birthDetails = null)
    {
        $this
            ->setPersonId($personId)
            ->setName($name)
            ->setFormerName($formerName)
            ->setBirthDetails($birthDetails);
    }
    /**
     * Get personId value
     * @return string|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param string $personId
     * @return \StructType\PersonNameBirthType
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: string
        if (!is_null($personId) && !is_string($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\PersonNameBirthType
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get formerName value
     * @return \StructType\PersonNameType|null
     */
    public function getFormerName()
    {
        return $this->formerName;
    }
    /**
     * Set formerName value
     * @param \StructType\PersonNameType $formerName
     * @return \StructType\PersonNameBirthType
     */
    public function setFormerName(\StructType\PersonNameType $formerName = null)
    {
        $this->formerName = $formerName;
        return $this;
    }
    /**
     * Get birthDetails value
     * @return \StructType\BirthDetailsType|null
     */
    public function getBirthDetails()
    {
        return $this->birthDetails;
    }
    /**
     * Set birthDetails value
     * @param \StructType\BirthDetailsType $birthDetails
     * @return \StructType\PersonNameBirthType
     */
    public function setBirthDetails(\StructType\BirthDetailsType $birthDetails = null)
    {
        $this->birthDetails = $birthDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonNameBirthType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
