<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personIds StructType
 * @subpackage Structs
 */
class PersonIds extends AbstractStructBase
{
    /**
     * The personId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var string[]
     */
    public $personId;
    /**
     * Constructor method for personIds
     * @uses PersonIds::setPersonId()
     * @param string[] $personId
     */
    public function __construct(array $personId = array())
    {
        $this
            ->setPersonId($personId);
    }
    /**
     * Get personId value
     * @return string[]|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @throws \InvalidArgumentException
     * @param string[] $personId
     * @return \StructType\PersonIds
     */
    public function setPersonId(array $personId = array())
    {
        foreach ($personId as $personIdsPersonIdItem) {
            // validation for constraint: itemType
            if (!is_string($personIdsPersonIdItem)) {
                throw new \InvalidArgumentException(sprintf('The personId property can only contain items of string, "%s" given', is_object($personIdsPersonIdItem) ? get_class($personIdsPersonIdItem) : gettype($personIdsPersonIdItem)), __LINE__);
            }
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Add item to personId value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonIds
     */
    public function addToPersonId($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The personId property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->personId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonIds
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
