<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentType StructType
 * @subpackage Structs
 */
class PaymentType extends AbstractStructBase
{
    /**
     * The directDebit
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $directDebit;
    /**
     * The creditCard
     * @var \StructType\CreditCardType
     */
    public $creditCard;
    /**
     * Constructor method for paymentType
     * @uses PaymentType::setDirectDebit()
     * @uses PaymentType::setCreditCard()
     * @param bool $directDebit
     * @param \StructType\CreditCardType $creditCard
     */
    public function __construct($directDebit = null, \StructType\CreditCardType $creditCard = null)
    {
        $this
            ->setDirectDebit($directDebit)
            ->setCreditCard($creditCard);
    }
    /**
     * Get directDebit value
     * @return bool|null
     */
    public function getDirectDebit()
    {
        return $this->directDebit;
    }
    /**
     * Set directDebit value
     * @param bool $directDebit
     * @return \StructType\PaymentType
     */
    public function setDirectDebit($directDebit = null)
    {
        // validation for constraint: pattern
        if (is_scalar($directDebit) && !preg_match('/true/', $directDebit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($directDebit, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($directDebit) && !is_bool($directDebit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($directDebit)), __LINE__);
        }
        $this->directDebit = $directDebit;
        return $this;
    }
    /**
     * Get creditCard value
     * @return \StructType\CreditCardType|null
     */
    public function getCreditCard()
    {
        return $this->creditCard;
    }
    /**
     * Set creditCard value
     * @param \StructType\CreditCardType $creditCard
     * @return \StructType\PaymentType
     */
    public function setCreditCard(\StructType\CreditCardType $creditCard = null)
    {
        $this->creditCard = $creditCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
