<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for outboundAgentType StructType
 * @subpackage Structs
 */
class OutboundAgentType extends AbstractStructBase
{
    /**
     * The agentAbn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $agentAbn;
    /**
     * The agentNo
     * Meta informations extracted from the WSDL
     * - documentation: Internal Ascot Ids ie N9
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $agentNo;
    /**
     * The agentName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $agentName;
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - documentation: CompanyPartnershipUnincorporateStructure
     * @var \StructType\NameIndexEntityType
     */
    public $organisation;
    /**
     * The person
     * Meta informations extracted from the WSDL
     * - documentation: Sole TraderIndividual
     * @var \StructType\IndividualType
     */
    public $person;
    /**
     * The business
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business[]
     */
    public $business;
    /**
     * Constructor method for outboundAgentType
     * @uses OutboundAgentType::setAgentAbn()
     * @uses OutboundAgentType::setAgentNo()
     * @uses OutboundAgentType::setAgentName()
     * @uses OutboundAgentType::setOrganisation()
     * @uses OutboundAgentType::setPerson()
     * @uses OutboundAgentType::setBusiness()
     * @param string $agentAbn
     * @param int $agentNo
     * @param string $agentName
     * @param \StructType\NameIndexEntityType $organisation
     * @param \StructType\IndividualType $person
     * @param \StructType\Business[] $business
     */
    public function __construct($agentAbn = null, $agentNo = null, $agentName = null, \StructType\NameIndexEntityType $organisation = null, \StructType\IndividualType $person = null, array $business = array())
    {
        $this
            ->setAgentAbn($agentAbn)
            ->setAgentNo($agentNo)
            ->setAgentName($agentName)
            ->setOrganisation($organisation)
            ->setPerson($person)
            ->setBusiness($business);
    }
    /**
     * Get agentAbn value
     * @return string|null
     */
    public function getAgentAbn()
    {
        return $this->agentAbn;
    }
    /**
     * Set agentAbn value
     * @param string $agentAbn
     * @return \StructType\OutboundAgentType
     */
    public function setAgentAbn($agentAbn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($agentAbn) && strlen($agentAbn) > 11) || (is_array($agentAbn) && count($agentAbn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($agentAbn) ? strlen($agentAbn) : count($agentAbn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($agentAbn) && strlen($agentAbn) < 11) || (is_array($agentAbn) && count($agentAbn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($agentAbn) && !preg_match('/([0-9]{11})/', $agentAbn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($agentAbn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($agentAbn) && !is_string($agentAbn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentAbn)), __LINE__);
        }
        $this->agentAbn = $agentAbn;
        return $this;
    }
    /**
     * Get agentNo value
     * @return int|null
     */
    public function getAgentNo()
    {
        return $this->agentNo;
    }
    /**
     * Set agentNo value
     * @param int $agentNo
     * @return \StructType\OutboundAgentType
     */
    public function setAgentNo($agentNo = null)
    {
        // validation for constraint: maxInclusive
        if ($agentNo > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $agentNo), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($agentNo < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $agentNo), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($agentNo) && !is_numeric($agentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($agentNo)), __LINE__);
        }
        $this->agentNo = $agentNo;
        return $this;
    }
    /**
     * Get agentName value
     * @return string|null
     */
    public function getAgentName()
    {
        return $this->agentName;
    }
    /**
     * Set agentName value
     * @param string $agentName
     * @return \StructType\OutboundAgentType
     */
    public function setAgentName($agentName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($agentName) && strlen($agentName) > 200) || (is_array($agentName) && count($agentName) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($agentName) ? strlen($agentName) : count($agentName)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($agentName) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $agentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($agentName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($agentName) && !is_string($agentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentName)), __LINE__);
        }
        $this->agentName = $agentName;
        return $this;
    }
    /**
     * Get organisation value
     * @return \StructType\NameIndexEntityType|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\NameIndexEntityType $organisation
     * @return \StructType\OutboundAgentType
     */
    public function setOrganisation(\StructType\NameIndexEntityType $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get person value
     * @return \StructType\IndividualType|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @param \StructType\IndividualType $person
     * @return \StructType\OutboundAgentType
     */
    public function setPerson(\StructType\IndividualType $person = null)
    {
        $this->person = $person;
        return $this;
    }
    /**
     * Get business value
     * @return \StructType\Business[]|null
     */
    public function getBusiness()
    {
        return $this->business;
    }
    /**
     * Set business value
     * @throws \InvalidArgumentException
     * @param \StructType\Business[] $business
     * @return \StructType\OutboundAgentType
     */
    public function setBusiness(array $business = array())
    {
        foreach ($business as $outboundAgentTypeBusinessItem) {
            // validation for constraint: itemType
            if (!$outboundAgentTypeBusinessItem instanceof \StructType\Business) {
                throw new \InvalidArgumentException(sprintf('The business property can only contain items of \StructType\Business, "%s" given', is_object($outboundAgentTypeBusinessItem) ? get_class($outboundAgentTypeBusinessItem) : gettype($outboundAgentTypeBusinessItem)), __LINE__);
            }
        }
        $this->business = $business;
        return $this;
    }
    /**
     * Add item to business value
     * @throws \InvalidArgumentException
     * @param \StructType\Business $item
     * @return \StructType\OutboundAgentType
     */
    public function addToBusiness(\StructType\Business $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business) {
            throw new \InvalidArgumentException(sprintf('The business property can only contain items of \StructType\Business, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->business[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutboundAgentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
