<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for organisationType StructType
 * @subpackage Structs
 */
class OrganisationType extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Holder name or business name, according with roleCategory value in filter element | composite person name or organisation name
     * - maxLength: 200
     * - minLength: 1
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $name;
    /**
     * The acn
     * Meta informations extracted from the WSDL
     * - documentation: Company only
     * - minOccurs: 0
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $acn;
    /**
     * The orgNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orgNumber;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - documentation: ~Outbound~
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\AddressExtType[]
     */
    public $address;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: email address
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: ~Outbound~
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - documentation: ~Outbound~
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for organisationType
     * @uses OrganisationType::setName()
     * @uses OrganisationType::setAcn()
     * @uses OrganisationType::setOrgNumber()
     * @uses OrganisationType::setAddress()
     * @uses OrganisationType::setEmailAddress()
     * @uses OrganisationType::setStartDate()
     * @uses OrganisationType::setEndDate()
     * @param string $name
     * @param int $acn
     * @param string $orgNumber
     * @param \StructType\AddressExtType[] $address
     * @param string $emailAddress
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct($name = null, $acn = null, $orgNumber = null, array $address = array(), $emailAddress = null, $startDate = null, $endDate = null)
    {
        $this
            ->setName($name)
            ->setAcn($acn)
            ->setOrgNumber($orgNumber)
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\OrganisationType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($name) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($name, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get acn value
     * @return int|null
     */
    public function getAcn()
    {
        return $this->acn;
    }
    /**
     * Set acn value
     * @param int $acn
     * @return \StructType\OrganisationType
     */
    public function setAcn($acn = null)
    {
        // validation for constraint: maxInclusive
        if ($acn > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $acn), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($acn < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $acn), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($acn) && !is_numeric($acn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($acn)), __LINE__);
        }
        $this->acn = $acn;
        return $this;
    }
    /**
     * Get orgNumber value
     * @return string|null
     */
    public function getOrgNumber()
    {
        return $this->orgNumber;
    }
    /**
     * Set orgNumber value
     * @param string $orgNumber
     * @return \StructType\OrganisationType
     */
    public function setOrgNumber($orgNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orgNumber) && !is_string($orgNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgNumber)), __LINE__);
        }
        $this->orgNumber = $orgNumber;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\AddressExtType[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressExtType[] $address
     * @return \StructType\OrganisationType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $organisationTypeAddressItem) {
            // validation for constraint: itemType
            if (!$organisationTypeAddressItem instanceof \StructType\AddressExtType) {
                throw new \InvalidArgumentException(sprintf('The address property can only contain items of \StructType\AddressExtType, "%s" given', is_object($organisationTypeAddressItem) ? get_class($organisationTypeAddressItem) : gettype($organisationTypeAddressItem)), __LINE__);
            }
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressExtType $item
     * @return \StructType\OrganisationType
     */
    public function addToAddress(\StructType\AddressExtType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressExtType) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of \StructType\AddressExtType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \StructType\OrganisationType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\OrganisationType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: minInclusive
        if ($startDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\OrganisationType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: minInclusive
        if ($endDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrganisationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
