<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for organisationNameType StructType
 * @subpackage Structs
 */
class OrganisationNameType extends AbstractStructBase
{
    /**
     * The organisationShortName1
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $organisationShortName1;
    /**
     * The organisationShortName2
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $organisationShortName2;
    /**
     * The effectiveFrom
     * Meta informations extracted from the WSDL
     * - documentation: Date from which a name is effective.
     * @var string
     */
    public $effectiveFrom;
    /**
     * The effectiveTo
     * Meta informations extracted from the WSDL
     * - documentation: Date from which a name is no longer effective. An empty value (or no effectiveTo element) indicates that the parent element is current.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveTo;
    /**
     * The deleteIndicator
     * @var string
     */
    public $deleteIndicator;
    /**
     * The organisationName
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $organisationName;
    /**
     * Constructor method for organisationNameType
     * @uses OrganisationNameType::setOrganisationShortName1()
     * @uses OrganisationNameType::setOrganisationShortName2()
     * @uses OrganisationNameType::setEffectiveFrom()
     * @uses OrganisationNameType::setEffectiveTo()
     * @uses OrganisationNameType::setDeleteIndicator()
     * @uses OrganisationNameType::setOrganisationName()
     * @param string $organisationShortName1
     * @param string $organisationShortName2
     * @param string $effectiveFrom
     * @param string $effectiveTo
     * @param string $deleteIndicator
     * @param string $organisationName
     */
    public function __construct($organisationShortName1 = null, $organisationShortName2 = null, $effectiveFrom = null, $effectiveTo = null, $deleteIndicator = null, $organisationName = null)
    {
        $this
            ->setOrganisationShortName1($organisationShortName1)
            ->setOrganisationShortName2($organisationShortName2)
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveTo($effectiveTo)
            ->setDeleteIndicator($deleteIndicator)
            ->setOrganisationName($organisationName);
    }
    /**
     * Get organisationShortName1 value
     * @return string|null
     */
    public function getOrganisationShortName1()
    {
        return $this->organisationShortName1;
    }
    /**
     * Set organisationShortName1 value
     * @param string $organisationShortName1
     * @return \StructType\OrganisationNameType
     */
    public function setOrganisationShortName1($organisationShortName1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organisationShortName1) && strlen($organisationShortName1) > 200) || (is_array($organisationShortName1) && count($organisationShortName1) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($organisationShortName1) ? strlen($organisationShortName1) : count($organisationShortName1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organisationShortName1) && !is_string($organisationShortName1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationShortName1)), __LINE__);
        }
        $this->organisationShortName1 = $organisationShortName1;
        return $this;
    }
    /**
     * Get organisationShortName2 value
     * @return string|null
     */
    public function getOrganisationShortName2()
    {
        return $this->organisationShortName2;
    }
    /**
     * Set organisationShortName2 value
     * @param string $organisationShortName2
     * @return \StructType\OrganisationNameType
     */
    public function setOrganisationShortName2($organisationShortName2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organisationShortName2) && strlen($organisationShortName2) > 200) || (is_array($organisationShortName2) && count($organisationShortName2) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($organisationShortName2) ? strlen($organisationShortName2) : count($organisationShortName2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organisationShortName2) && !is_string($organisationShortName2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationShortName2)), __LINE__);
        }
        $this->organisationShortName2 = $organisationShortName2;
        return $this;
    }
    /**
     * Get effectiveFrom value
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return $this->effectiveFrom;
    }
    /**
     * Set effectiveFrom value
     * @param string $effectiveFrom
     * @return \StructType\OrganisationNameType
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveFrom)), __LINE__);
        }
        $this->effectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Get effectiveTo value
     * @return string|null
     */
    public function getEffectiveTo()
    {
        return $this->effectiveTo;
    }
    /**
     * Set effectiveTo value
     * @param string $effectiveTo
     * @return \StructType\OrganisationNameType
     */
    public function setEffectiveTo($effectiveTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveTo) && !is_string($effectiveTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveTo)), __LINE__);
        }
        $this->effectiveTo = $effectiveTo;
        return $this;
    }
    /**
     * Get deleteIndicator value
     * @return string|null
     */
    public function getDeleteIndicator()
    {
        return $this->deleteIndicator;
    }
    /**
     * Set deleteIndicator value
     * @uses \EnumType\IndicatorType::valueIsValid()
     * @uses \EnumType\IndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deleteIndicator
     * @return \StructType\OrganisationNameType
     */
    public function setDeleteIndicator($deleteIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicatorType::valueIsValid($deleteIndicator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deleteIndicator, implode(', ', \EnumType\IndicatorType::getValidValues())), __LINE__);
        }
        $this->deleteIndicator = $deleteIndicator;
        return $this;
    }
    /**
     * Get organisationName value
     * @return string|null
     */
    public function getOrganisationName()
    {
        return $this->organisationName;
    }
    /**
     * Set organisationName value
     * @param string $organisationName
     * @return \StructType\OrganisationNameType
     */
    public function setOrganisationName($organisationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organisationName) && strlen($organisationName) > 200) || (is_array($organisationName) && count($organisationName) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($organisationName) ? strlen($organisationName) : count($organisationName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organisationName) && !is_string($organisationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationName)), __LINE__);
        }
        $this->organisationName = $organisationName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrganisationNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
