<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for officeholderType StructType
 * @subpackage Structs
 */
class OfficeholderType extends AbstractStructBase
{
    /**
     * The organisation
     * @var \StructType\OrganisationType
     */
    public $organisation;
    /**
     * The individual
     * @var \StructType\IndividualType
     */
    public $individual;
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * Constructor method for officeholderType
     * @uses OfficeholderType::setOrganisation()
     * @uses OfficeholderType::setIndividual()
     * @uses OfficeholderType::setRole()
     * @param \StructType\OrganisationType $organisation
     * @param \StructType\IndividualType $individual
     * @param string $role
     */
    public function __construct(\StructType\OrganisationType $organisation = null, \StructType\IndividualType $individual = null, $role = null)
    {
        $this
            ->setOrganisation($organisation)
            ->setIndividual($individual)
            ->setRole($role);
    }
    /**
     * Get organisation value
     * @return \StructType\OrganisationType|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\OrganisationType $organisation
     * @return \StructType\OfficeholderType
     */
    public function setOrganisation(\StructType\OrganisationType $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get individual value
     * @return \StructType\IndividualType|null
     */
    public function getIndividual()
    {
        return $this->individual;
    }
    /**
     * Set individual value
     * @param \StructType\IndividualType $individual
     * @return \StructType\OfficeholderType
     */
    public function setIndividual(\StructType\IndividualType $individual = null)
    {
        $this->individual = $individual;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @uses \EnumType\OfficeholderRole::valueIsValid()
     * @uses \EnumType\OfficeholderRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $role
     * @return \StructType\OfficeholderType
     */
    public function setRole($role = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OfficeholderRole::valueIsValid($role)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $role, implode(', ', \EnumType\OfficeholderRole::getValidValues())), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OfficeholderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
