<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for objectionType StructType
 * @subpackage Structs
 */
class ObjectionType extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The descriptions
     * Meta informations extracted from the WSDL
     * - maxLength: 250
     * @var string
     */
    public $descriptions;
    /**
     * The context
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Context
     */
    public $context;
    /**
     * Constructor method for objectionType
     * @uses ObjectionType::setCode()
     * @uses ObjectionType::setDescriptions()
     * @uses ObjectionType::setContext()
     * @param string $code
     * @param string $descriptions
     * @param \StructType\Context $context
     */
    public function __construct($code = null, $descriptions = null, \StructType\Context $context = null)
    {
        $this
            ->setCode($code)
            ->setDescriptions($descriptions)
            ->setContext($context);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @uses \EnumType\Code::valueIsValid()
     * @uses \EnumType\Code::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\ObjectionType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Code::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \EnumType\Code::getValidValues())), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get descriptions value
     * @return string|null
     */
    public function getDescriptions()
    {
        return $this->descriptions;
    }
    /**
     * Set descriptions value
     * @param string $descriptions
     * @return \StructType\ObjectionType
     */
    public function setDescriptions($descriptions = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descriptions) && strlen($descriptions) > 250) || (is_array($descriptions) && count($descriptions) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($descriptions) ? strlen($descriptions) : count($descriptions)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descriptions) && !is_string($descriptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptions)), __LINE__);
        }
        $this->descriptions = $descriptions;
        return $this;
    }
    /**
     * Get context value
     * @return \StructType\Context|null
     */
    public function getContext()
    {
        return $this->context;
    }
    /**
     * Set context value
     * @param \StructType\Context $context
     * @return \StructType\ObjectionType
     */
    public function setContext(\StructType\Context $context = null)
    {
        $this->context = $context;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ObjectionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
