<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nniEntityWithAgentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Base Organisation extended to indicate if the lodger can act for it
 * @subpackage Structs
 */
class NniEntityWithAgentType extends NameIndexEntityType
{
    /**
     * The agent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Agent
     */
    public $agent;
    /**
     * The businessNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\OutboundBusinessNameType[]
     */
    public $businessNames;
    /**
     * Constructor method for nniEntityWithAgentType
     * @uses NniEntityWithAgentType::setAgent()
     * @uses NniEntityWithAgentType::setBusinessNames()
     * @param \StructType\Agent $agent
     * @param \StructType\OutboundBusinessNameType[] $businessNames
     */
    public function __construct(\StructType\Agent $agent = null, array $businessNames = array())
    {
        $this
            ->setAgent($agent)
            ->setBusinessNames($businessNames);
    }
    /**
     * Get agent value
     * @return \StructType\Agent|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \StructType\Agent $agent
     * @return \StructType\NniEntityWithAgentType
     */
    public function setAgent(\StructType\Agent $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get businessNames value
     * @return \StructType\OutboundBusinessNameType[]|null
     */
    public function getBusinessNames()
    {
        return $this->businessNames;
    }
    /**
     * Set businessNames value
     * @throws \InvalidArgumentException
     * @param \StructType\OutboundBusinessNameType[] $businessNames
     * @return \StructType\NniEntityWithAgentType
     */
    public function setBusinessNames(array $businessNames = array())
    {
        foreach ($businessNames as $nniEntityWithAgentTypeBusinessNamesItem) {
            // validation for constraint: itemType
            if (!$nniEntityWithAgentTypeBusinessNamesItem instanceof \StructType\OutboundBusinessNameType) {
                throw new \InvalidArgumentException(sprintf('The businessNames property can only contain items of \StructType\OutboundBusinessNameType, "%s" given', is_object($nniEntityWithAgentTypeBusinessNamesItem) ? get_class($nniEntityWithAgentTypeBusinessNamesItem) : gettype($nniEntityWithAgentTypeBusinessNamesItem)), __LINE__);
            }
        }
        $this->businessNames = $businessNames;
        return $this;
    }
    /**
     * Add item to businessNames value
     * @throws \InvalidArgumentException
     * @param \StructType\OutboundBusinessNameType $item
     * @return \StructType\NniEntityWithAgentType
     */
    public function addToBusinessNames(\StructType\OutboundBusinessNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OutboundBusinessNameType) {
            throw new \InvalidArgumentException(sprintf('The businessNames property can only contain items of \StructType\OutboundBusinessNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->businessNames[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NniEntityWithAgentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
