<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for messageTimestampType StructType
 * @subpackage Structs
 */
class MessageTimestampType extends AbstractStructBase
{
    /**
     * The timestamp
     * @var string
     */
    public $timestamp;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * @var string
     */
    public $source;
    /**
     * Constructor method for messageTimestampType
     * @uses MessageTimestampType::setTimestamp()
     * @uses MessageTimestampType::setSource()
     * @param string $timestamp
     * @param string $source
     */
    public function __construct($timestamp = null, $source = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setSource($source);
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\MessageTimestampType
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\MessageTimestampType
     */
    public function setSource($source = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($source) && strlen($source) > 50) || (is_array($source) && count($source) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($source) ? strlen($source) : count($source)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageTimestampType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
