<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for messageEventType StructType
 * @subpackage Structs
 */
class MessageEventType extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $errorCode;
    /**
     * The serverityCode
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $serverityCode;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The locationPath
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $locationPath;
    /**
     * The details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string[]
     */
    public $details;
    /**
     * Constructor method for messageEventType
     * @uses MessageEventType::setErrorCode()
     * @uses MessageEventType::setServerityCode()
     * @uses MessageEventType::setDescription()
     * @uses MessageEventType::setLocationPath()
     * @uses MessageEventType::setDetails()
     * @param string $errorCode
     * @param string $serverityCode
     * @param string $description
     * @param string $locationPath
     * @param string[] $details
     */
    public function __construct($errorCode = null, $serverityCode = null, $description = null, $locationPath = null, array $details = array())
    {
        $this
            ->setErrorCode($errorCode)
            ->setServerityCode($serverityCode)
            ->setDescription($description)
            ->setLocationPath($locationPath)
            ->setDetails($details);
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \StructType\MessageEventType
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($errorCode) && strlen($errorCode) > 20) || (is_array($errorCode) && count($errorCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($errorCode) ? strlen($errorCode) : count($errorCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($errorCode) && strlen($errorCode) < 1) || (is_array($errorCode) && count($errorCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get serverityCode value
     * @return string|null
     */
    public function getServerityCode()
    {
        return $this->serverityCode;
    }
    /**
     * Set serverityCode value
     * @param string $serverityCode
     * @return \StructType\MessageEventType
     */
    public function setServerityCode($serverityCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serverityCode) && strlen($serverityCode) > 20) || (is_array($serverityCode) && count($serverityCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($serverityCode) ? strlen($serverityCode) : count($serverityCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($serverityCode) && strlen($serverityCode) < 1) || (is_array($serverityCode) && count($serverityCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serverityCode) && !is_string($serverityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serverityCode)), __LINE__);
        }
        $this->serverityCode = $serverityCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MessageEventType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 60) || (is_array($description) && count($description) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get locationPath value
     * @return string|null
     */
    public function getLocationPath()
    {
        return $this->locationPath;
    }
    /**
     * Set locationPath value
     * @param string $locationPath
     * @return \StructType\MessageEventType
     */
    public function setLocationPath($locationPath = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($locationPath) && strlen($locationPath) > 1000) || (is_array($locationPath) && count($locationPath) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($locationPath) ? strlen($locationPath) : count($locationPath)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($locationPath) && strlen($locationPath) < 1) || (is_array($locationPath) && count($locationPath) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($locationPath) && !is_string($locationPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationPath)), __LINE__);
        }
        $this->locationPath = $locationPath;
        return $this;
    }
    /**
     * Get details value
     * @return string[]|null
     */
    public function getDetails()
    {
        return $this->details;
    }
    /**
     * Set details value
     * @throws \InvalidArgumentException
     * @param string[] $details
     * @return \StructType\MessageEventType
     */
    public function setDetails(array $details = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($details) && strlen($details) > 1000) || (is_array($details) && count($details) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($details) ? strlen($details) : count($details)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($details) && strlen($details) < 1) || (is_array($details) && count($details) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($details as $messageEventTypeDetailsItem) {
            // validation for constraint: itemType
            if (!is_string($messageEventTypeDetailsItem)) {
                throw new \InvalidArgumentException(sprintf('The details property can only contain items of string, "%s" given', is_object($messageEventTypeDetailsItem) ? get_class($messageEventTypeDetailsItem) : gettype($messageEventTypeDetailsItem)), __LINE__);
            }
        }
        $this->details = $details;
        return $this;
    }
    /**
     * Add item to details value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MessageEventType
     */
    public function addToDetails($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 1000) || (is_array($item) && count($item) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The details property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->details[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageEventType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
