<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for localityState StructType
 * @subpackage Structs
 */
class LocalityState extends AbstractStructBase
{
    /**
     * The locality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locality;
    /**
     * The state
     * @var string
     */
    public $state;
    /**
     * Constructor method for localityState
     * @uses LocalityState::setLocality()
     * @uses LocalityState::setState()
     * @param string $locality
     * @param string $state
     */
    public function __construct($locality = null, $state = null)
    {
        $this
            ->setLocality($locality)
            ->setState($state);
    }
    /**
     * Get locality value
     * @return string|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @param string $locality
     * @return \StructType\LocalityState
     */
    public function setLocality($locality = null)
    {
        // validation for constraint: string
        if (!is_null($locality) && !is_string($locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locality)), __LINE__);
        }
        $this->locality = $locality;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\LocalityState
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocalityState
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
