<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemSummaryType StructType
 * @subpackage Structs
 */
class ItemSummaryType extends AbstractStructBase
{
    /**
     * The messageType
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $messageType;
    /**
     * The messageVersion
     * @var int
     */
    public $messageVersion;
    /**
     * The reportingEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EntityType
     */
    public $reportingEntity;
    /**
     * The itemIdentifier
     * @var \StructType\OutboundItemIdentifierType
     */
    public $itemIdentifier;
    /**
     * The lodgedDate
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $lodgedDate;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResultType
     */
    public $result;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for itemSummaryType
     * @uses ItemSummaryType::setMessageType()
     * @uses ItemSummaryType::setMessageVersion()
     * @uses ItemSummaryType::setReportingEntity()
     * @uses ItemSummaryType::setItemIdentifier()
     * @uses ItemSummaryType::setLodgedDate()
     * @uses ItemSummaryType::setResult()
     * @uses ItemSummaryType::setStatus()
     * @param string $messageType
     * @param int $messageVersion
     * @param \StructType\EntityType $reportingEntity
     * @param \StructType\OutboundItemIdentifierType $itemIdentifier
     * @param string $lodgedDate
     * @param \StructType\ResultType $result
     * @param string $status
     */
    public function __construct($messageType = null, $messageVersion = null, \StructType\EntityType $reportingEntity = null, \StructType\OutboundItemIdentifierType $itemIdentifier = null, $lodgedDate = null, \StructType\ResultType $result = null, $status = null)
    {
        $this
            ->setMessageType($messageType)
            ->setMessageVersion($messageVersion)
            ->setReportingEntity($reportingEntity)
            ->setItemIdentifier($itemIdentifier)
            ->setLodgedDate($lodgedDate)
            ->setResult($result)
            ->setStatus($status);
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param string $messageType
     * @return \StructType\ItemSummaryType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageType) && strlen($messageType) > 100) || (is_array($messageType) && count($messageType) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($messageType) ? strlen($messageType) : count($messageType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageType) && strlen($messageType) < 1) || (is_array($messageType) && count($messageType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get messageVersion value
     * @return int|null
     */
    public function getMessageVersion()
    {
        return $this->messageVersion;
    }
    /**
     * Set messageVersion value
     * @param int $messageVersion
     * @return \StructType\ItemSummaryType
     */
    public function setMessageVersion($messageVersion = null)
    {
        // validation for constraint: int
        if (!is_null($messageVersion) && !is_numeric($messageVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageVersion)), __LINE__);
        }
        $this->messageVersion = $messageVersion;
        return $this;
    }
    /**
     * Get reportingEntity value
     * @return \StructType\EntityType|null
     */
    public function getReportingEntity()
    {
        return $this->reportingEntity;
    }
    /**
     * Set reportingEntity value
     * @param \StructType\EntityType $reportingEntity
     * @return \StructType\ItemSummaryType
     */
    public function setReportingEntity(\StructType\EntityType $reportingEntity = null)
    {
        $this->reportingEntity = $reportingEntity;
        return $this;
    }
    /**
     * Get itemIdentifier value
     * @return \StructType\OutboundItemIdentifierType|null
     */
    public function getItemIdentifier()
    {
        return $this->itemIdentifier;
    }
    /**
     * Set itemIdentifier value
     * @param \StructType\OutboundItemIdentifierType $itemIdentifier
     * @return \StructType\ItemSummaryType
     */
    public function setItemIdentifier(\StructType\OutboundItemIdentifierType $itemIdentifier = null)
    {
        $this->itemIdentifier = $itemIdentifier;
        return $this;
    }
    /**
     * Get lodgedDate value
     * @return string|null
     */
    public function getLodgedDate()
    {
        return $this->lodgedDate;
    }
    /**
     * Set lodgedDate value
     * @param string $lodgedDate
     * @return \StructType\ItemSummaryType
     */
    public function setLodgedDate($lodgedDate = null)
    {
        // validation for constraint: minInclusive
        if ($lodgedDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $lodgedDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lodgedDate) && !is_string($lodgedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lodgedDate)), __LINE__);
        }
        $this->lodgedDate = $lodgedDate;
        return $this;
    }
    /**
     * Get result value
     * @return \StructType\ResultType|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\ResultType $result
     * @return \StructType\ItemSummaryType
     */
    public function setResult(\StructType\ResultType $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ApplicationStatusType::valueIsValid()
     * @uses \EnumType\ApplicationStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ItemSummaryType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ApplicationStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ApplicationStatusType::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
