<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for item StructType
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - maxLength: 60
     * - minLength: 1
     * @var string[]
     */
    public $description;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $amount;
    /**
     * The taxCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: GST Goods And Services Tax
     * - maxLength: 3
     * @var string
     */
    public $taxCode;
    /**
     * The taxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The referenceNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $referenceNo;
    /**
     * Constructor method for item
     * @uses Item::setDescription()
     * @uses Item::setAmount()
     * @uses Item::setTaxCode()
     * @uses Item::setTaxAmount()
     * @uses Item::setReferenceNo()
     * @param string[] $description
     * @param float $amount
     * @param string $taxCode
     * @param float $taxAmount
     * @param string $referenceNo
     */
    public function __construct(array $description = array(), $amount = null, $taxCode = null, $taxAmount = null, $referenceNo = null)
    {
        $this
            ->setDescription($description)
            ->setAmount($amount)
            ->setTaxCode($taxCode)
            ->setTaxAmount($taxAmount)
            ->setReferenceNo($referenceNo);
    }
    /**
     * Get description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \StructType\Item
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 60) || (is_array($description) && count($description) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($description as $itemDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($itemDescriptionItem)) {
                throw new \InvalidArgumentException(sprintf('The description property can only contain items of string, "%s" given', is_object($itemDescriptionItem) ? get_class($itemDescriptionItem) : gettype($itemDescriptionItem)), __LINE__);
            }
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Item
     */
    public function addToDescription($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 60) || (is_array($item) && count($item) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\Item
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($amount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $amount), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $amount), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get taxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param string $taxCode
     * @return \StructType\Item
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($taxCode) && strlen($taxCode) > 3) || (is_array($taxCode) && count($taxCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($taxCode) ? strlen($taxCode) : count($taxCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCode)), __LINE__);
        }
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\Item
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($taxAmount) && strlen(substr($taxAmount, strpos($taxAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($taxAmount, strpos($taxAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($taxAmount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $taxAmount), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($taxAmount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $taxAmount), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get referenceNo value
     * @return string|null
     */
    public function getReferenceNo()
    {
        return $this->referenceNo;
    }
    /**
     * Set referenceNo value
     * @param string $referenceNo
     * @return \StructType\Item
     */
    public function setReferenceNo($referenceNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($referenceNo) && strlen($referenceNo) > 16) || (is_array($referenceNo) && count($referenceNo) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($referenceNo) ? strlen($referenceNo) : count($referenceNo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenceNo) && !is_string($referenceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNo)), __LINE__);
        }
        $this->referenceNo = $referenceNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
