<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for invoiceType StructType
 * @subpackage Structs
 */
class InvoiceType extends AbstractStructBase
{
    /**
     * The debtor
     * @var \StructType\DebtorType
     */
    public $debtor;
    /**
     * The dateIssued
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateIssued;
    /**
     * The invoicePeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoicePeriod
     */
    public $invoicePeriod;
    /**
     * The paid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionsType
     */
    public $paid;
    /**
     * The oldUnpaid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionsType
     */
    public $oldUnpaid;
    /**
     * The currentUnpaid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionsType
     */
    public $currentUnpaid;
    /**
     * The totalDue
     * Meta informations extracted from the WSDL
     * - documentation: Sum of currentUnpaid.total and oldUnpaid.total | Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $totalDue;
    /**
     * The asicPaymentDetails
     * @var \StructType\AsicPaymentDetails
     */
    public $asicPaymentDetails;
    /**
     * Constructor method for invoiceType
     * @uses InvoiceType::setDebtor()
     * @uses InvoiceType::setDateIssued()
     * @uses InvoiceType::setInvoicePeriod()
     * @uses InvoiceType::setPaid()
     * @uses InvoiceType::setOldUnpaid()
     * @uses InvoiceType::setCurrentUnpaid()
     * @uses InvoiceType::setTotalDue()
     * @uses InvoiceType::setAsicPaymentDetails()
     * @param \StructType\DebtorType $debtor
     * @param string $dateIssued
     * @param \StructType\InvoicePeriod $invoicePeriod
     * @param \StructType\TransactionsType $paid
     * @param \StructType\TransactionsType $oldUnpaid
     * @param \StructType\TransactionsType $currentUnpaid
     * @param float $totalDue
     * @param \StructType\AsicPaymentDetails $asicPaymentDetails
     */
    public function __construct(\StructType\DebtorType $debtor = null, $dateIssued = null, \StructType\InvoicePeriod $invoicePeriod = null, \StructType\TransactionsType $paid = null, \StructType\TransactionsType $oldUnpaid = null, \StructType\TransactionsType $currentUnpaid = null, $totalDue = null, \StructType\AsicPaymentDetails $asicPaymentDetails = null)
    {
        $this
            ->setDebtor($debtor)
            ->setDateIssued($dateIssued)
            ->setInvoicePeriod($invoicePeriod)
            ->setPaid($paid)
            ->setOldUnpaid($oldUnpaid)
            ->setCurrentUnpaid($currentUnpaid)
            ->setTotalDue($totalDue)
            ->setAsicPaymentDetails($asicPaymentDetails);
    }
    /**
     * Get debtor value
     * @return \StructType\DebtorType|null
     */
    public function getDebtor()
    {
        return $this->debtor;
    }
    /**
     * Set debtor value
     * @param \StructType\DebtorType $debtor
     * @return \StructType\InvoiceType
     */
    public function setDebtor(\StructType\DebtorType $debtor = null)
    {
        $this->debtor = $debtor;
        return $this;
    }
    /**
     * Get dateIssued value
     * @return string|null
     */
    public function getDateIssued()
    {
        return $this->dateIssued;
    }
    /**
     * Set dateIssued value
     * @param string $dateIssued
     * @return \StructType\InvoiceType
     */
    public function setDateIssued($dateIssued = null)
    {
        // validation for constraint: minInclusive
        if ($dateIssued < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateIssued), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateIssued) && !is_string($dateIssued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateIssued)), __LINE__);
        }
        $this->dateIssued = $dateIssued;
        return $this;
    }
    /**
     * Get invoicePeriod value
     * @return \StructType\InvoicePeriod|null
     */
    public function getInvoicePeriod()
    {
        return $this->invoicePeriod;
    }
    /**
     * Set invoicePeriod value
     * @param \StructType\InvoicePeriod $invoicePeriod
     * @return \StructType\InvoiceType
     */
    public function setInvoicePeriod(\StructType\InvoicePeriod $invoicePeriod = null)
    {
        $this->invoicePeriod = $invoicePeriod;
        return $this;
    }
    /**
     * Get paid value
     * @return \StructType\TransactionsType|null
     */
    public function getPaid()
    {
        return $this->paid;
    }
    /**
     * Set paid value
     * @param \StructType\TransactionsType $paid
     * @return \StructType\InvoiceType
     */
    public function setPaid(\StructType\TransactionsType $paid = null)
    {
        $this->paid = $paid;
        return $this;
    }
    /**
     * Get oldUnpaid value
     * @return \StructType\TransactionsType|null
     */
    public function getOldUnpaid()
    {
        return $this->oldUnpaid;
    }
    /**
     * Set oldUnpaid value
     * @param \StructType\TransactionsType $oldUnpaid
     * @return \StructType\InvoiceType
     */
    public function setOldUnpaid(\StructType\TransactionsType $oldUnpaid = null)
    {
        $this->oldUnpaid = $oldUnpaid;
        return $this;
    }
    /**
     * Get currentUnpaid value
     * @return \StructType\TransactionsType|null
     */
    public function getCurrentUnpaid()
    {
        return $this->currentUnpaid;
    }
    /**
     * Set currentUnpaid value
     * @param \StructType\TransactionsType $currentUnpaid
     * @return \StructType\InvoiceType
     */
    public function setCurrentUnpaid(\StructType\TransactionsType $currentUnpaid = null)
    {
        $this->currentUnpaid = $currentUnpaid;
        return $this;
    }
    /**
     * Get totalDue value
     * @return float|null
     */
    public function getTotalDue()
    {
        return $this->totalDue;
    }
    /**
     * Set totalDue value
     * @param float $totalDue
     * @return \StructType\InvoiceType
     */
    public function setTotalDue($totalDue = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($totalDue) && strlen(substr($totalDue, strpos($totalDue, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($totalDue, strpos($totalDue, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($totalDue > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $totalDue), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($totalDue < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $totalDue), __LINE__);
        }
        $this->totalDue = $totalDue;
        return $this;
    }
    /**
     * Get asicPaymentDetails value
     * @return \StructType\AsicPaymentDetails|null
     */
    public function getAsicPaymentDetails()
    {
        return $this->asicPaymentDetails;
    }
    /**
     * Set asicPaymentDetails value
     * @param \StructType\AsicPaymentDetails $asicPaymentDetails
     * @return \StructType\InvoiceType
     */
    public function setAsicPaymentDetails(\StructType\AsicPaymentDetails $asicPaymentDetails = null)
    {
        $this->asicPaymentDetails = $asicPaymentDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
