<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for invoiceItems StructType
 * @subpackage Structs
 */
class InvoiceItems extends AbstractStructBase
{
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - maxOccurs: 50
     * @var \StructType\Item[]
     */
    public $item;
    /**
     * Constructor method for invoiceItems
     * @uses InvoiceItems::setItem()
     * @param \StructType\Item[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get item value
     * @return \StructType\Item[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item[] $item
     * @return \StructType\InvoiceItems
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $invoiceItemsItemItem) {
            // validation for constraint: itemType
            if (!$invoiceItemsItemItem instanceof \StructType\Item) {
                throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\Item, "%s" given', is_object($invoiceItemsItemItem) ? get_class($invoiceItemsItemItem) : gettype($invoiceItemsItemItem)), __LINE__);
            }
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item $item
     * @return \StructType\InvoiceItems
     */
    public function addToItem(\StructType\Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\Item, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
