<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for invoice StructType
 * @subpackage Structs
 */
class Invoice extends AbstractStructBase
{
    /**
     * The asicName
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * @var string
     */
    public $asicName;
    /**
     * The asicAbn
     * Meta informations extracted from the WSDL
     * - maxLength: 11
     * - minLength: 11
     * @var string
     */
    public $asicAbn;
    /**
     * The debtorName
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $debtorName;
    /**
     * The debtorAddress
     * @var string
     */
    public $debtorAddress;
    /**
     * The debtorAccount
     * @var \StructType\FssAccountType
     */
    public $debtorAccount;
    /**
     * The debtorBpayReference
     * Meta informations extracted from the WSDL
     * - maxLength: 13
     * @var string
     */
    public $debtorBpayReference;
    /**
     * The debtorDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * @var \StructType\DebtorDetail[]
     */
    public $debtorDetail;
    /**
     * The invoiceIssueDate
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $invoiceIssueDate;
    /**
     * The invoiceItems
     * @var \StructType\InvoiceItems
     */
    public $invoiceItems;
    /**
     * The asicBpayBillerCode
     * Meta informations extracted from the WSDL
     * - maxLength: 5
     * @var string
     */
    public $asicBpayBillerCode;
    /**
     * The asicTitleForPayment
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $asicTitleForPayment;
    /**
     * The asicAddressForPayment
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $asicAddressForPayment;
    /**
     * The asicPhoneForQueries
     * Meta informations extracted from the WSDL
     * - maxLength: 12
     * @var string
     */
    public $asicPhoneForQueries;
    /**
     * Constructor method for invoice
     * @uses Invoice::setAsicName()
     * @uses Invoice::setAsicAbn()
     * @uses Invoice::setDebtorName()
     * @uses Invoice::setDebtorAddress()
     * @uses Invoice::setDebtorAccount()
     * @uses Invoice::setDebtorBpayReference()
     * @uses Invoice::setDebtorDetail()
     * @uses Invoice::setInvoiceIssueDate()
     * @uses Invoice::setInvoiceItems()
     * @uses Invoice::setAsicBpayBillerCode()
     * @uses Invoice::setAsicTitleForPayment()
     * @uses Invoice::setAsicAddressForPayment()
     * @uses Invoice::setAsicPhoneForQueries()
     * @param string $asicName
     * @param string $asicAbn
     * @param string $debtorName
     * @param string $debtorAddress
     * @param \StructType\FssAccountType $debtorAccount
     * @param string $debtorBpayReference
     * @param \StructType\DebtorDetail[] $debtorDetail
     * @param string $invoiceIssueDate
     * @param \StructType\InvoiceItems $invoiceItems
     * @param string $asicBpayBillerCode
     * @param string $asicTitleForPayment
     * @param string $asicAddressForPayment
     * @param string $asicPhoneForQueries
     */
    public function __construct($asicName = null, $asicAbn = null, $debtorName = null, $debtorAddress = null, \StructType\FssAccountType $debtorAccount = null, $debtorBpayReference = null, array $debtorDetail = array(), $invoiceIssueDate = null, \StructType\InvoiceItems $invoiceItems = null, $asicBpayBillerCode = null, $asicTitleForPayment = null, $asicAddressForPayment = null, $asicPhoneForQueries = null)
    {
        $this
            ->setAsicName($asicName)
            ->setAsicAbn($asicAbn)
            ->setDebtorName($debtorName)
            ->setDebtorAddress($debtorAddress)
            ->setDebtorAccount($debtorAccount)
            ->setDebtorBpayReference($debtorBpayReference)
            ->setDebtorDetail($debtorDetail)
            ->setInvoiceIssueDate($invoiceIssueDate)
            ->setInvoiceItems($invoiceItems)
            ->setAsicBpayBillerCode($asicBpayBillerCode)
            ->setAsicTitleForPayment($asicTitleForPayment)
            ->setAsicAddressForPayment($asicAddressForPayment)
            ->setAsicPhoneForQueries($asicPhoneForQueries);
    }
    /**
     * Get asicName value
     * @return string|null
     */
    public function getAsicName()
    {
        return $this->asicName;
    }
    /**
     * Set asicName value
     * @param string $asicName
     * @return \StructType\Invoice
     */
    public function setAsicName($asicName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asicName) && strlen($asicName) > 50) || (is_array($asicName) && count($asicName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($asicName) ? strlen($asicName) : count($asicName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asicName) && !is_string($asicName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asicName)), __LINE__);
        }
        $this->asicName = $asicName;
        return $this;
    }
    /**
     * Get asicAbn value
     * @return string|null
     */
    public function getAsicAbn()
    {
        return $this->asicAbn;
    }
    /**
     * Set asicAbn value
     * @param string $asicAbn
     * @return \StructType\Invoice
     */
    public function setAsicAbn($asicAbn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asicAbn) && strlen($asicAbn) > 11) || (is_array($asicAbn) && count($asicAbn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($asicAbn) ? strlen($asicAbn) : count($asicAbn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($asicAbn) && strlen($asicAbn) < 11) || (is_array($asicAbn) && count($asicAbn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asicAbn) && !is_string($asicAbn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asicAbn)), __LINE__);
        }
        $this->asicAbn = $asicAbn;
        return $this;
    }
    /**
     * Get debtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->debtorName;
    }
    /**
     * Set debtorName value
     * @param string $debtorName
     * @return \StructType\Invoice
     */
    public function setDebtorName($debtorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorName) && strlen($debtorName) > 200) || (is_array($debtorName) && count($debtorName) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($debtorName) ? strlen($debtorName) : count($debtorName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorName) && !is_string($debtorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorName)), __LINE__);
        }
        $this->debtorName = $debtorName;
        return $this;
    }
    /**
     * Get debtorAddress value
     * @return string|null
     */
    public function getDebtorAddress()
    {
        return $this->debtorAddress;
    }
    /**
     * Set debtorAddress value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorAddress
     * @return \StructType\Invoice
     */
    public function setDebtorAddress($debtorAddress = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($debtorAddress)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $debtorAddress, implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->debtorAddress = $debtorAddress;
        return $this;
    }
    /**
     * Get debtorAccount value
     * @return \StructType\FssAccountType|null
     */
    public function getDebtorAccount()
    {
        return $this->debtorAccount;
    }
    /**
     * Set debtorAccount value
     * @param \StructType\FssAccountType $debtorAccount
     * @return \StructType\Invoice
     */
    public function setDebtorAccount(\StructType\FssAccountType $debtorAccount = null)
    {
        $this->debtorAccount = $debtorAccount;
        return $this;
    }
    /**
     * Get debtorBpayReference value
     * @return string|null
     */
    public function getDebtorBpayReference()
    {
        return $this->debtorBpayReference;
    }
    /**
     * Set debtorBpayReference value
     * @param string $debtorBpayReference
     * @return \StructType\Invoice
     */
    public function setDebtorBpayReference($debtorBpayReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorBpayReference) && strlen($debtorBpayReference) > 13) || (is_array($debtorBpayReference) && count($debtorBpayReference) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($debtorBpayReference) ? strlen($debtorBpayReference) : count($debtorBpayReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBpayReference) && !is_string($debtorBpayReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBpayReference)), __LINE__);
        }
        $this->debtorBpayReference = $debtorBpayReference;
        return $this;
    }
    /**
     * Get debtorDetail value
     * @return \StructType\DebtorDetail[]|null
     */
    public function getDebtorDetail()
    {
        return $this->debtorDetail;
    }
    /**
     * Set debtorDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorDetail[] $debtorDetail
     * @return \StructType\Invoice
     */
    public function setDebtorDetail(array $debtorDetail = array())
    {
        foreach ($debtorDetail as $invoiceDebtorDetailItem) {
            // validation for constraint: itemType
            if (!$invoiceDebtorDetailItem instanceof \StructType\DebtorDetail) {
                throw new \InvalidArgumentException(sprintf('The debtorDetail property can only contain items of \StructType\DebtorDetail, "%s" given', is_object($invoiceDebtorDetailItem) ? get_class($invoiceDebtorDetailItem) : gettype($invoiceDebtorDetailItem)), __LINE__);
            }
        }
        $this->debtorDetail = $debtorDetail;
        return $this;
    }
    /**
     * Add item to debtorDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorDetail $item
     * @return \StructType\Invoice
     */
    public function addToDebtorDetail(\StructType\DebtorDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DebtorDetail) {
            throw new \InvalidArgumentException(sprintf('The debtorDetail property can only contain items of \StructType\DebtorDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->debtorDetail[] = $item;
        return $this;
    }
    /**
     * Get invoiceIssueDate value
     * @return string|null
     */
    public function getInvoiceIssueDate()
    {
        return $this->invoiceIssueDate;
    }
    /**
     * Set invoiceIssueDate value
     * @param string $invoiceIssueDate
     * @return \StructType\Invoice
     */
    public function setInvoiceIssueDate($invoiceIssueDate = null)
    {
        // validation for constraint: minInclusive
        if ($invoiceIssueDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $invoiceIssueDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceIssueDate) && !is_string($invoiceIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceIssueDate)), __LINE__);
        }
        $this->invoiceIssueDate = $invoiceIssueDate;
        return $this;
    }
    /**
     * Get invoiceItems value
     * @return \StructType\InvoiceItems|null
     */
    public function getInvoiceItems()
    {
        return $this->invoiceItems;
    }
    /**
     * Set invoiceItems value
     * @param \StructType\InvoiceItems $invoiceItems
     * @return \StructType\Invoice
     */
    public function setInvoiceItems(\StructType\InvoiceItems $invoiceItems = null)
    {
        $this->invoiceItems = $invoiceItems;
        return $this;
    }
    /**
     * Get asicBpayBillerCode value
     * @return string|null
     */
    public function getAsicBpayBillerCode()
    {
        return $this->asicBpayBillerCode;
    }
    /**
     * Set asicBpayBillerCode value
     * @param string $asicBpayBillerCode
     * @return \StructType\Invoice
     */
    public function setAsicBpayBillerCode($asicBpayBillerCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asicBpayBillerCode) && strlen($asicBpayBillerCode) > 5) || (is_array($asicBpayBillerCode) && count($asicBpayBillerCode) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($asicBpayBillerCode) ? strlen($asicBpayBillerCode) : count($asicBpayBillerCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asicBpayBillerCode) && !is_string($asicBpayBillerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asicBpayBillerCode)), __LINE__);
        }
        $this->asicBpayBillerCode = $asicBpayBillerCode;
        return $this;
    }
    /**
     * Get asicTitleForPayment value
     * @return string|null
     */
    public function getAsicTitleForPayment()
    {
        return $this->asicTitleForPayment;
    }
    /**
     * Set asicTitleForPayment value
     * @param string $asicTitleForPayment
     * @return \StructType\Invoice
     */
    public function setAsicTitleForPayment($asicTitleForPayment = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asicTitleForPayment) && strlen($asicTitleForPayment) > 100) || (is_array($asicTitleForPayment) && count($asicTitleForPayment) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($asicTitleForPayment) ? strlen($asicTitleForPayment) : count($asicTitleForPayment)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asicTitleForPayment) && !is_string($asicTitleForPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asicTitleForPayment)), __LINE__);
        }
        $this->asicTitleForPayment = $asicTitleForPayment;
        return $this;
    }
    /**
     * Get asicAddressForPayment value
     * @return string|null
     */
    public function getAsicAddressForPayment()
    {
        return $this->asicAddressForPayment;
    }
    /**
     * Set asicAddressForPayment value
     * @param string $asicAddressForPayment
     * @return \StructType\Invoice
     */
    public function setAsicAddressForPayment($asicAddressForPayment = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asicAddressForPayment) && strlen($asicAddressForPayment) > 100) || (is_array($asicAddressForPayment) && count($asicAddressForPayment) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($asicAddressForPayment) ? strlen($asicAddressForPayment) : count($asicAddressForPayment)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asicAddressForPayment) && !is_string($asicAddressForPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asicAddressForPayment)), __LINE__);
        }
        $this->asicAddressForPayment = $asicAddressForPayment;
        return $this;
    }
    /**
     * Get asicPhoneForQueries value
     * @return string|null
     */
    public function getAsicPhoneForQueries()
    {
        return $this->asicPhoneForQueries;
    }
    /**
     * Set asicPhoneForQueries value
     * @param string $asicPhoneForQueries
     * @return \StructType\Invoice
     */
    public function setAsicPhoneForQueries($asicPhoneForQueries = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asicPhoneForQueries) && strlen($asicPhoneForQueries) > 12) || (is_array($asicPhoneForQueries) && count($asicPhoneForQueries) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($asicPhoneForQueries) ? strlen($asicPhoneForQueries) : count($asicPhoneForQueries)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asicPhoneForQueries) && !is_string($asicPhoneForQueries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asicPhoneForQueries)), __LINE__);
        }
        $this->asicPhoneForQueries = $asicPhoneForQueries;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Invoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
