<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for individualType StructType
 * @subpackage Structs
 */
class IndividualType extends AbstractStructBase
{
    /**
     * The name
     * @var \StructType\PersonNameType
     */
    public $name;
    /**
     * The previousName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $previousName;
    /**
     * The birthDetails
     * Meta informations extracted from the WSDL
     * - documentation: ~Private~
     * - minOccurs: 0
     * @var \StructType\BirthDetailsType
     */
    public $birthDetails;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressExtType
     */
    public $address;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - documentation: email address
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * The changeOfIndividual
     * Meta informations extracted from the WSDL
     * - documentation: Change Of Details only
     * - minOccurs: 0
     * @var bool
     */
    public $changeOfIndividual;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: ~Outbound~
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - documentation: ~Outbound~
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for individualType
     * @uses IndividualType::setName()
     * @uses IndividualType::setPreviousName()
     * @uses IndividualType::setBirthDetails()
     * @uses IndividualType::setAddress()
     * @uses IndividualType::setEmailAddress()
     * @uses IndividualType::setChangeOfIndividual()
     * @uses IndividualType::setStartDate()
     * @uses IndividualType::setEndDate()
     * @param \StructType\PersonNameType $name
     * @param \StructType\PersonNameType $previousName
     * @param \StructType\BirthDetailsType $birthDetails
     * @param \StructType\AddressExtType $address
     * @param string $emailAddress
     * @param bool $changeOfIndividual
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct(\StructType\PersonNameType $name = null, \StructType\PersonNameType $previousName = null, \StructType\BirthDetailsType $birthDetails = null, \StructType\AddressExtType $address = null, $emailAddress = null, $changeOfIndividual = null, $startDate = null, $endDate = null)
    {
        $this
            ->setName($name)
            ->setPreviousName($previousName)
            ->setBirthDetails($birthDetails)
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setChangeOfIndividual($changeOfIndividual)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\IndividualType
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get previousName value
     * @return \StructType\PersonNameType|null
     */
    public function getPreviousName()
    {
        return $this->previousName;
    }
    /**
     * Set previousName value
     * @param \StructType\PersonNameType $previousName
     * @return \StructType\IndividualType
     */
    public function setPreviousName(\StructType\PersonNameType $previousName = null)
    {
        $this->previousName = $previousName;
        return $this;
    }
    /**
     * Get birthDetails value
     * @return \StructType\BirthDetailsType|null
     */
    public function getBirthDetails()
    {
        return $this->birthDetails;
    }
    /**
     * Set birthDetails value
     * @param \StructType\BirthDetailsType $birthDetails
     * @return \StructType\IndividualType
     */
    public function setBirthDetails(\StructType\BirthDetailsType $birthDetails = null)
    {
        $this->birthDetails = $birthDetails;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\AddressExtType|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\AddressExtType $address
     * @return \StructType\IndividualType
     */
    public function setAddress(\StructType\AddressExtType $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get emailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->emailAddress) ? $this->emailAddress : null;
    }
    /**
     * Set emailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\IndividualType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->emailAddress);
        } else {
            $this->emailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get changeOfIndividual value
     * @return bool|null
     */
    public function getChangeOfIndividual()
    {
        return $this->changeOfIndividual;
    }
    /**
     * Set changeOfIndividual value
     * @param bool $changeOfIndividual
     * @return \StructType\IndividualType
     */
    public function setChangeOfIndividual($changeOfIndividual = null)
    {
        // validation for constraint: boolean
        if (!is_null($changeOfIndividual) && !is_bool($changeOfIndividual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($changeOfIndividual)), __LINE__);
        }
        $this->changeOfIndividual = $changeOfIndividual;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\IndividualType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: minInclusive
        if ($startDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\IndividualType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: minInclusive
        if ($endDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IndividualType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
