<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for individualLodgeType StructType
 * @subpackage Structs
 */
class IndividualLodgeType extends AbstractStructBase
{
    /**
     * The name
     * @var \StructType\PersonNameLodgeType
     */
    public $name;
    /**
     * The birthDetails
     * @var \StructType\BirthDetailsLodgeType
     */
    public $birthDetails;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressLodgeType
     */
    public $address;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - documentation: email address
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * Constructor method for individualLodgeType
     * @uses IndividualLodgeType::setName()
     * @uses IndividualLodgeType::setBirthDetails()
     * @uses IndividualLodgeType::setAddress()
     * @uses IndividualLodgeType::setEmailAddress()
     * @param \StructType\PersonNameLodgeType $name
     * @param \StructType\BirthDetailsLodgeType $birthDetails
     * @param \StructType\AddressLodgeType $address
     * @param string $emailAddress
     */
    public function __construct(\StructType\PersonNameLodgeType $name = null, \StructType\BirthDetailsLodgeType $birthDetails = null, \StructType\AddressLodgeType $address = null, $emailAddress = null)
    {
        $this
            ->setName($name)
            ->setBirthDetails($birthDetails)
            ->setAddress($address)
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get name value
     * @return \StructType\PersonNameLodgeType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\PersonNameLodgeType $name
     * @return \StructType\IndividualLodgeType
     */
    public function setName(\StructType\PersonNameLodgeType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get birthDetails value
     * @return \StructType\BirthDetailsLodgeType|null
     */
    public function getBirthDetails()
    {
        return $this->birthDetails;
    }
    /**
     * Set birthDetails value
     * @param \StructType\BirthDetailsLodgeType $birthDetails
     * @return \StructType\IndividualLodgeType
     */
    public function setBirthDetails(\StructType\BirthDetailsLodgeType $birthDetails = null)
    {
        $this->birthDetails = $birthDetails;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\AddressLodgeType|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\AddressLodgeType $address
     * @return \StructType\IndividualLodgeType
     */
    public function setAddress(\StructType\AddressLodgeType $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get emailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->emailAddress) ? $this->emailAddress : null;
    }
    /**
     * Set emailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\IndividualLodgeType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->emailAddress);
        } else {
            $this->emailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IndividualLodgeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
