<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for identifierType StructType
 * @subpackage Structs
 */
class IdentifierType extends AbstractStructBase
{
    /**
     * The identifierValue
     * Meta informations extracted from the WSDL
     * - documentation: The identifierValue stores the value of the identifier.
     * - maxLength: 20
     * @var string
     */
    public $identifierValue;
    /**
     * The identifierStatusCode
     * Meta informations extracted from the WSDL
     * - documentation: The identifierStatusCode describes the current status of the identifier (e.g Active, Inactive).
     * - minOccurs: 0
     * - maxLength: 4
     * @var string
     */
    public $identifierStatusCode;
    /**
     * The issuingPartyCode
     * Meta informations extracted from the WSDL
     * - documentation: The issuingPartyCode describes the agency which issued the identifier.
     * - minOccurs: 0
     * - maxLength: 6
     * @var string
     */
    public $issuingPartyCode;
    /**
     * The replacedIndicator
     * Meta informations extracted from the WSDL
     * - documentation: The replacedIndicator stores a value to denote whether or not the identifier has been replaced.
     * - minOccurs: 0
     * @var string
     */
    public $replacedIndicator;
    /**
     * The effectiveFrom
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveFrom defines the date from which an identifier is effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveFrom;
    /**
     * The effectiveTo
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveTo defines the date from which an identifier is no longer effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveTo;
    /**
     * The deleteIndicator
     * Meta informations extracted from the WSDL
     * - documentation: The deleteIndicator indicates whether the identifier record has been logically deleted from the system.
     * - minOccurs: 0
     * @var string
     */
    public $deleteIndicator;
    /**
     * The numberHeading
     * Meta informations extracted from the WSDL
     * - documentation: ACN Australian Company NumberARBN Australian Registered Body NumberNumberARSN Australian Registered Scheme Number
     * - minOccurs: 0
     * @var string
     */
    public $numberHeading;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $number;
    /**
     * Constructor method for identifierType
     * @uses IdentifierType::setIdentifierValue()
     * @uses IdentifierType::setIdentifierStatusCode()
     * @uses IdentifierType::setIssuingPartyCode()
     * @uses IdentifierType::setReplacedIndicator()
     * @uses IdentifierType::setEffectiveFrom()
     * @uses IdentifierType::setEffectiveTo()
     * @uses IdentifierType::setDeleteIndicator()
     * @uses IdentifierType::setNumberHeading()
     * @uses IdentifierType::setNumber()
     * @param string $identifierValue
     * @param string $identifierStatusCode
     * @param string $issuingPartyCode
     * @param string $replacedIndicator
     * @param string $effectiveFrom
     * @param string $effectiveTo
     * @param string $deleteIndicator
     * @param string $numberHeading
     * @param int $number
     */
    public function __construct($identifierValue = null, $identifierStatusCode = null, $issuingPartyCode = null, $replacedIndicator = null, $effectiveFrom = null, $effectiveTo = null, $deleteIndicator = null, $numberHeading = null, $number = null)
    {
        $this
            ->setIdentifierValue($identifierValue)
            ->setIdentifierStatusCode($identifierStatusCode)
            ->setIssuingPartyCode($issuingPartyCode)
            ->setReplacedIndicator($replacedIndicator)
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveTo($effectiveTo)
            ->setDeleteIndicator($deleteIndicator)
            ->setNumberHeading($numberHeading)
            ->setNumber($number);
    }
    /**
     * Get identifierValue value
     * @return string|null
     */
    public function getIdentifierValue()
    {
        return $this->identifierValue;
    }
    /**
     * Set identifierValue value
     * @param string $identifierValue
     * @return \StructType\IdentifierType
     */
    public function setIdentifierValue($identifierValue = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identifierValue) && strlen($identifierValue) > 20) || (is_array($identifierValue) && count($identifierValue) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($identifierValue) ? strlen($identifierValue) : count($identifierValue)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identifierValue) && !is_string($identifierValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifierValue)), __LINE__);
        }
        $this->identifierValue = $identifierValue;
        return $this;
    }
    /**
     * Get identifierStatusCode value
     * @return string|null
     */
    public function getIdentifierStatusCode()
    {
        return $this->identifierStatusCode;
    }
    /**
     * Set identifierStatusCode value
     * @param string $identifierStatusCode
     * @return \StructType\IdentifierType
     */
    public function setIdentifierStatusCode($identifierStatusCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identifierStatusCode) && strlen($identifierStatusCode) > 4) || (is_array($identifierStatusCode) && count($identifierStatusCode) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($identifierStatusCode) ? strlen($identifierStatusCode) : count($identifierStatusCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identifierStatusCode) && !is_string($identifierStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifierStatusCode)), __LINE__);
        }
        $this->identifierStatusCode = $identifierStatusCode;
        return $this;
    }
    /**
     * Get issuingPartyCode value
     * @return string|null
     */
    public function getIssuingPartyCode()
    {
        return $this->issuingPartyCode;
    }
    /**
     * Set issuingPartyCode value
     * @param string $issuingPartyCode
     * @return \StructType\IdentifierType
     */
    public function setIssuingPartyCode($issuingPartyCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issuingPartyCode) && strlen($issuingPartyCode) > 6) || (is_array($issuingPartyCode) && count($issuingPartyCode) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($issuingPartyCode) ? strlen($issuingPartyCode) : count($issuingPartyCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issuingPartyCode) && !is_string($issuingPartyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuingPartyCode)), __LINE__);
        }
        $this->issuingPartyCode = $issuingPartyCode;
        return $this;
    }
    /**
     * Get replacedIndicator value
     * @return string|null
     */
    public function getReplacedIndicator()
    {
        return $this->replacedIndicator;
    }
    /**
     * Set replacedIndicator value
     * @uses \EnumType\IndicatorType::valueIsValid()
     * @uses \EnumType\IndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $replacedIndicator
     * @return \StructType\IdentifierType
     */
    public function setReplacedIndicator($replacedIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicatorType::valueIsValid($replacedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $replacedIndicator, implode(', ', \EnumType\IndicatorType::getValidValues())), __LINE__);
        }
        $this->replacedIndicator = $replacedIndicator;
        return $this;
    }
    /**
     * Get effectiveFrom value
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return $this->effectiveFrom;
    }
    /**
     * Set effectiveFrom value
     * @param string $effectiveFrom
     * @return \StructType\IdentifierType
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveFrom)), __LINE__);
        }
        $this->effectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Get effectiveTo value
     * @return string|null
     */
    public function getEffectiveTo()
    {
        return $this->effectiveTo;
    }
    /**
     * Set effectiveTo value
     * @param string $effectiveTo
     * @return \StructType\IdentifierType
     */
    public function setEffectiveTo($effectiveTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveTo) && !is_string($effectiveTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveTo)), __LINE__);
        }
        $this->effectiveTo = $effectiveTo;
        return $this;
    }
    /**
     * Get deleteIndicator value
     * @return string|null
     */
    public function getDeleteIndicator()
    {
        return $this->deleteIndicator;
    }
    /**
     * Set deleteIndicator value
     * @uses \EnumType\IndicatorType::valueIsValid()
     * @uses \EnumType\IndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deleteIndicator
     * @return \StructType\IdentifierType
     */
    public function setDeleteIndicator($deleteIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicatorType::valueIsValid($deleteIndicator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deleteIndicator, implode(', ', \EnumType\IndicatorType::getValidValues())), __LINE__);
        }
        $this->deleteIndicator = $deleteIndicator;
        return $this;
    }
    /**
     * Get numberHeading value
     * @return string|null
     */
    public function getNumberHeading()
    {
        return $this->numberHeading;
    }
    /**
     * Set numberHeading value
     * @uses \EnumType\NumberHeadingType::valueIsValid()
     * @uses \EnumType\NumberHeadingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberHeading
     * @return \StructType\IdentifierType
     */
    public function setNumberHeading($numberHeading = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NumberHeadingType::valueIsValid($numberHeading)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberHeading, implode(', ', \EnumType\NumberHeadingType::getValidValues())), __LINE__);
        }
        $this->numberHeading = $numberHeading;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\IdentifierType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: maxInclusive
        if ($number > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $number), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($number < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $number), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($number) && !is_numeric($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
