<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for geographicType StructType
 * @subpackage Structs
 */
class GeographicType extends AbstractStructBase
{
    /**
     * The addressLine1
     * Meta informations extracted from the WSDL
     * - documentation: The addressLine1 stores the first line of an uncomponentised address. This doesn't include the suburb/place/locality, state, postcode, country or DPID.
     * - minOccurs: 0
     * - maxLength: 38
     * @var string
     */
    public $addressLine1;
    /**
     * The addressLine2
     * Meta informations extracted from the WSDL
     * - documentation: The addressLine2 stores the second line of an uncomponentised address. This doesn't include the suburb/place/locality, state, postcode, country or DPID.
     * - minOccurs: 0
     * - maxLength: 38
     * @var string
     */
    public $addressLine2;
    /**
     * The suburb
     * Meta informations extracted from the WSDL
     * - documentation: The suburb stores the full name of the general locality containing the specific address.
     * - minOccurs: 0
     * - maxLength: 46
     * @var string
     */
    public $suburb;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: The postcode stores the numeric descriptor for a postal delivery area, aligned with a Suburb, Place or Locality.
     * - maxLength: 12
     * @var string
     */
    public $postcode;
    /**
     * The stateCode
     * Meta informations extracted from the WSDL
     * - documentation: The StateCode stores the defined state or territory abbreviation for the state or territory in which the address is located.
     * - minOccurs: 0
     * - maxLength: 3
     * @var string
     */
    public $stateCode;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: The countryCode stores the code representing the country in which an overseas address is located.
     * - minOccurs: 0
     * - maxLength: 3
     * @var string
     */
    public $countryCode;
    /**
     * The DPID
     * Meta informations extracted from the WSDL
     * - documentation: The DPID (Delivery Point Identifier). The DPID stores the numeric descriptor for a postal delivery point which is equal to a unique physical address.
     * - minOccurs: 0
     * @var int
     */
    public $DPID;
    /**
     * The DPIDStatusCode
     * Meta informations extracted from the WSDL
     * - documentation: The DPIDStatusCode describes the status of the DPID of the address record (e.g. active, inactive).
     * - minOccurs: 0
     * - maxLength: 4
     * @var string
     */
    public $DPIDStatusCode;
    /**
     * The lastConfirmedDate
     * Meta informations extracted from the WSDL
     * - documentation: The lastConfirmedDate stores the date this address was last confirmed as being correct. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $lastConfirmedDate;
    /**
     * The reliabilityIndicatorCode
     * Meta informations extracted from the WSDL
     * - documentation: The reliabilityIndicatorCode indicates whether the address record is currently reliable.
     * - minOccurs: 0
     * @var string
     */
    public $reliabilityIndicatorCode;
    /**
     * The reliabilityIndicatorDate
     * Meta informations extracted from the WSDL
     * - documentation: The reliabiltyIndicatorDate stores the date the address was determined to be reliable/unreliable. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $reliabilityIndicatorDate;
    /**
     * The effectiveFrom
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveFrom defines the date from which an address is effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveFrom;
    /**
     * The effectiveTo
     * Meta informations extracted from the WSDL
     * - documentation: The effectiveTo defines the date from which an address is no longer effective. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveTo;
    /**
     * The deleteIndicator
     * Meta informations extracted from the WSDL
     * - documentation: The deleteIndicator indicates whether the address record has been logically deleted from the system.
     * - minOccurs: 0
     * @var string
     */
    public $deleteIndicator;
    /**
     * Constructor method for geographicType
     * @uses GeographicType::setAddressLine1()
     * @uses GeographicType::setAddressLine2()
     * @uses GeographicType::setSuburb()
     * @uses GeographicType::setPostcode()
     * @uses GeographicType::setStateCode()
     * @uses GeographicType::setCountryCode()
     * @uses GeographicType::setDPID()
     * @uses GeographicType::setDPIDStatusCode()
     * @uses GeographicType::setLastConfirmedDate()
     * @uses GeographicType::setReliabilityIndicatorCode()
     * @uses GeographicType::setReliabilityIndicatorDate()
     * @uses GeographicType::setEffectiveFrom()
     * @uses GeographicType::setEffectiveTo()
     * @uses GeographicType::setDeleteIndicator()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $suburb
     * @param string $postcode
     * @param string $stateCode
     * @param string $countryCode
     * @param int $dPID
     * @param string $dPIDStatusCode
     * @param string $lastConfirmedDate
     * @param string $reliabilityIndicatorCode
     * @param string $reliabilityIndicatorDate
     * @param string $effectiveFrom
     * @param string $effectiveTo
     * @param string $deleteIndicator
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $suburb = null, $postcode = null, $stateCode = null, $countryCode = null, $dPID = null, $dPIDStatusCode = null, $lastConfirmedDate = null, $reliabilityIndicatorCode = null, $reliabilityIndicatorDate = null, $effectiveFrom = null, $effectiveTo = null, $deleteIndicator = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setSuburb($suburb)
            ->setPostcode($postcode)
            ->setStateCode($stateCode)
            ->setCountryCode($countryCode)
            ->setDPID($dPID)
            ->setDPIDStatusCode($dPIDStatusCode)
            ->setLastConfirmedDate($lastConfirmedDate)
            ->setReliabilityIndicatorCode($reliabilityIndicatorCode)
            ->setReliabilityIndicatorDate($reliabilityIndicatorDate)
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveTo($effectiveTo)
            ->setDeleteIndicator($deleteIndicator);
    }
    /**
     * Get addressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->addressLine1;
    }
    /**
     * Set addressLine1 value
     * @param string $addressLine1
     * @return \StructType\GeographicType
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressLine1) && strlen($addressLine1) > 38) || (is_array($addressLine1) && count($addressLine1) > 38)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 38 element(s) or a scalar of 38 character(s) at most, "%d" length given', is_scalar($addressLine1) ? strlen($addressLine1) : count($addressLine1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        $this->addressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get addressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->addressLine2;
    }
    /**
     * Set addressLine2 value
     * @param string $addressLine2
     * @return \StructType\GeographicType
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressLine2) && strlen($addressLine2) > 38) || (is_array($addressLine2) && count($addressLine2) > 38)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 38 element(s) or a scalar of 38 character(s) at most, "%d" length given', is_scalar($addressLine2) ? strlen($addressLine2) : count($addressLine2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        $this->addressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get suburb value
     * @return string|null
     */
    public function getSuburb()
    {
        return $this->suburb;
    }
    /**
     * Set suburb value
     * @param string $suburb
     * @return \StructType\GeographicType
     */
    public function setSuburb($suburb = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($suburb) && strlen($suburb) > 46) || (is_array($suburb) && count($suburb) > 46)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 46 element(s) or a scalar of 46 character(s) at most, "%d" length given', is_scalar($suburb) ? strlen($suburb) : count($suburb)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($suburb) && !is_string($suburb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suburb)), __LINE__);
        }
        $this->suburb = $suburb;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\GeographicType
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postcode) && strlen($postcode) > 12) || (is_array($postcode) && count($postcode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($postcode) ? strlen($postcode) : count($postcode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get stateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->stateCode;
    }
    /**
     * Set stateCode value
     * @param string $stateCode
     * @return \StructType\GeographicType
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($stateCode) && strlen($stateCode) > 3) || (is_array($stateCode) && count($stateCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($stateCode) ? strlen($stateCode) : count($stateCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateCode)), __LINE__);
        }
        $this->stateCode = $stateCode;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\GeographicType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($countryCode) && strlen($countryCode) > 3) || (is_array($countryCode) && count($countryCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($countryCode) ? strlen($countryCode) : count($countryCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get DPID value
     * @return int|null
     */
    public function getDPID()
    {
        return $this->DPID;
    }
    /**
     * Set DPID value
     * @param int $dPID
     * @return \StructType\GeographicType
     */
    public function setDPID($dPID = null)
    {
        // validation for constraint: int
        if (!is_null($dPID) && !is_numeric($dPID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dPID)), __LINE__);
        }
        $this->DPID = $dPID;
        return $this;
    }
    /**
     * Get DPIDStatusCode value
     * @return string|null
     */
    public function getDPIDStatusCode()
    {
        return $this->DPIDStatusCode;
    }
    /**
     * Set DPIDStatusCode value
     * @param string $dPIDStatusCode
     * @return \StructType\GeographicType
     */
    public function setDPIDStatusCode($dPIDStatusCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dPIDStatusCode) && strlen($dPIDStatusCode) > 4) || (is_array($dPIDStatusCode) && count($dPIDStatusCode) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($dPIDStatusCode) ? strlen($dPIDStatusCode) : count($dPIDStatusCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dPIDStatusCode) && !is_string($dPIDStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dPIDStatusCode)), __LINE__);
        }
        $this->DPIDStatusCode = $dPIDStatusCode;
        return $this;
    }
    /**
     * Get lastConfirmedDate value
     * @return string|null
     */
    public function getLastConfirmedDate()
    {
        return $this->lastConfirmedDate;
    }
    /**
     * Set lastConfirmedDate value
     * @param string $lastConfirmedDate
     * @return \StructType\GeographicType
     */
    public function setLastConfirmedDate($lastConfirmedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastConfirmedDate) && !is_string($lastConfirmedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastConfirmedDate)), __LINE__);
        }
        $this->lastConfirmedDate = $lastConfirmedDate;
        return $this;
    }
    /**
     * Get reliabilityIndicatorCode value
     * @return string|null
     */
    public function getReliabilityIndicatorCode()
    {
        return $this->reliabilityIndicatorCode;
    }
    /**
     * Set reliabilityIndicatorCode value
     * @uses \EnumType\IndicatorType::valueIsValid()
     * @uses \EnumType\IndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reliabilityIndicatorCode
     * @return \StructType\GeographicType
     */
    public function setReliabilityIndicatorCode($reliabilityIndicatorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicatorType::valueIsValid($reliabilityIndicatorCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reliabilityIndicatorCode, implode(', ', \EnumType\IndicatorType::getValidValues())), __LINE__);
        }
        $this->reliabilityIndicatorCode = $reliabilityIndicatorCode;
        return $this;
    }
    /**
     * Get reliabilityIndicatorDate value
     * @return string|null
     */
    public function getReliabilityIndicatorDate()
    {
        return $this->reliabilityIndicatorDate;
    }
    /**
     * Set reliabilityIndicatorDate value
     * @param string $reliabilityIndicatorDate
     * @return \StructType\GeographicType
     */
    public function setReliabilityIndicatorDate($reliabilityIndicatorDate = null)
    {
        // validation for constraint: string
        if (!is_null($reliabilityIndicatorDate) && !is_string($reliabilityIndicatorDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reliabilityIndicatorDate)), __LINE__);
        }
        $this->reliabilityIndicatorDate = $reliabilityIndicatorDate;
        return $this;
    }
    /**
     * Get effectiveFrom value
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return $this->effectiveFrom;
    }
    /**
     * Set effectiveFrom value
     * @param string $effectiveFrom
     * @return \StructType\GeographicType
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveFrom)), __LINE__);
        }
        $this->effectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Get effectiveTo value
     * @return string|null
     */
    public function getEffectiveTo()
    {
        return $this->effectiveTo;
    }
    /**
     * Set effectiveTo value
     * @param string $effectiveTo
     * @return \StructType\GeographicType
     */
    public function setEffectiveTo($effectiveTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveTo) && !is_string($effectiveTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveTo)), __LINE__);
        }
        $this->effectiveTo = $effectiveTo;
        return $this;
    }
    /**
     * Get deleteIndicator value
     * @return string|null
     */
    public function getDeleteIndicator()
    {
        return $this->deleteIndicator;
    }
    /**
     * Set deleteIndicator value
     * @uses \EnumType\IndicatorType::valueIsValid()
     * @uses \EnumType\IndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deleteIndicator
     * @return \StructType\GeographicType
     */
    public function setDeleteIndicator($deleteIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicatorType::valueIsValid($deleteIndicator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deleteIndicator, implode(', ', \EnumType\IndicatorType::getValidValues())), __LINE__);
        }
        $this->deleteIndicator = $deleteIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeographicType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
