<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fssItemType StructType
 * @subpackage Structs
 */
class FssItemType extends AbstractStructBase
{
    /**
     * The reportingParty
     * Meta informations extracted from the WSDL
     * - documentation: party that lodgement is against
     * - minOccurs: 0
     * @var \StructType\FssAccountType
     */
    public $reportingParty;
    /**
     * The fee
     * @var \StructType\FeeType
     */
    public $fee;
    /**
     * The dateProcessed
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateProcessed;
    /**
     * The dateEffective
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateEffective;
    /**
     * The dateLastEffective
     * Meta informations extracted from the WSDL
     * - documentation: Required for 388, 405, 406
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateLastEffective;
    /**
     * The reversalIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $reversalIndicator;
    /**
     * The registryDocumentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Ascot document number
     * - maxLength: 9
     * - minLength: 1
     * - pattern: [A-Z0-9\.]*
     * @var string
     */
    public $registryDocumentNumber;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $amount;
    /**
     * The taxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The taxCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: GST Goods And Services Tax
     * - maxLength: 3
     * @var string
     */
    public $taxCode;
    /**
     * The channel
     * @var string
     */
    public $channel;
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $quantity;
    /**
     * The suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $suffix;
    /**
     * Constructor method for fssItemType
     * @uses FssItemType::setReportingParty()
     * @uses FssItemType::setFee()
     * @uses FssItemType::setDateProcessed()
     * @uses FssItemType::setDateEffective()
     * @uses FssItemType::setDateLastEffective()
     * @uses FssItemType::setReversalIndicator()
     * @uses FssItemType::setRegistryDocumentNumber()
     * @uses FssItemType::setAmount()
     * @uses FssItemType::setTaxAmount()
     * @uses FssItemType::setTaxCode()
     * @uses FssItemType::setChannel()
     * @uses FssItemType::setQuantity()
     * @uses FssItemType::setSuffix()
     * @param \StructType\FssAccountType $reportingParty
     * @param \StructType\FeeType $fee
     * @param string $dateProcessed
     * @param string $dateEffective
     * @param string $dateLastEffective
     * @param bool $reversalIndicator
     * @param string $registryDocumentNumber
     * @param float $amount
     * @param float $taxAmount
     * @param string $taxCode
     * @param string $channel
     * @param string $quantity
     * @param string $suffix
     */
    public function __construct(\StructType\FssAccountType $reportingParty = null, \StructType\FeeType $fee = null, $dateProcessed = null, $dateEffective = null, $dateLastEffective = null, $reversalIndicator = null, $registryDocumentNumber = null, $amount = null, $taxAmount = null, $taxCode = null, $channel = null, $quantity = null, $suffix = null)
    {
        $this
            ->setReportingParty($reportingParty)
            ->setFee($fee)
            ->setDateProcessed($dateProcessed)
            ->setDateEffective($dateEffective)
            ->setDateLastEffective($dateLastEffective)
            ->setReversalIndicator($reversalIndicator)
            ->setRegistryDocumentNumber($registryDocumentNumber)
            ->setAmount($amount)
            ->setTaxAmount($taxAmount)
            ->setTaxCode($taxCode)
            ->setChannel($channel)
            ->setQuantity($quantity)
            ->setSuffix($suffix);
    }
    /**
     * Get reportingParty value
     * @return \StructType\FssAccountType|null
     */
    public function getReportingParty()
    {
        return $this->reportingParty;
    }
    /**
     * Set reportingParty value
     * @param \StructType\FssAccountType $reportingParty
     * @return \StructType\FssItemType
     */
    public function setReportingParty(\StructType\FssAccountType $reportingParty = null)
    {
        $this->reportingParty = $reportingParty;
        return $this;
    }
    /**
     * Get fee value
     * @return \StructType\FeeType|null
     */
    public function getFee()
    {
        return $this->fee;
    }
    /**
     * Set fee value
     * @param \StructType\FeeType $fee
     * @return \StructType\FssItemType
     */
    public function setFee(\StructType\FeeType $fee = null)
    {
        $this->fee = $fee;
        return $this;
    }
    /**
     * Get dateProcessed value
     * @return string|null
     */
    public function getDateProcessed()
    {
        return $this->dateProcessed;
    }
    /**
     * Set dateProcessed value
     * @param string $dateProcessed
     * @return \StructType\FssItemType
     */
    public function setDateProcessed($dateProcessed = null)
    {
        // validation for constraint: minInclusive
        if ($dateProcessed < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateProcessed), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateProcessed) && !is_string($dateProcessed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateProcessed)), __LINE__);
        }
        $this->dateProcessed = $dateProcessed;
        return $this;
    }
    /**
     * Get dateEffective value
     * @return string|null
     */
    public function getDateEffective()
    {
        return $this->dateEffective;
    }
    /**
     * Set dateEffective value
     * @param string $dateEffective
     * @return \StructType\FssItemType
     */
    public function setDateEffective($dateEffective = null)
    {
        // validation for constraint: minInclusive
        if ($dateEffective < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateEffective), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateEffective) && !is_string($dateEffective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEffective)), __LINE__);
        }
        $this->dateEffective = $dateEffective;
        return $this;
    }
    /**
     * Get dateLastEffective value
     * @return string|null
     */
    public function getDateLastEffective()
    {
        return $this->dateLastEffective;
    }
    /**
     * Set dateLastEffective value
     * @param string $dateLastEffective
     * @return \StructType\FssItemType
     */
    public function setDateLastEffective($dateLastEffective = null)
    {
        // validation for constraint: minInclusive
        if ($dateLastEffective < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateLastEffective), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateLastEffective) && !is_string($dateLastEffective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateLastEffective)), __LINE__);
        }
        $this->dateLastEffective = $dateLastEffective;
        return $this;
    }
    /**
     * Get reversalIndicator value
     * @return bool|null
     */
    public function getReversalIndicator()
    {
        return $this->reversalIndicator;
    }
    /**
     * Set reversalIndicator value
     * @param bool $reversalIndicator
     * @return \StructType\FssItemType
     */
    public function setReversalIndicator($reversalIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($reversalIndicator) && !is_bool($reversalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reversalIndicator)), __LINE__);
        }
        $this->reversalIndicator = $reversalIndicator;
        return $this;
    }
    /**
     * Get registryDocumentNumber value
     * @return string|null
     */
    public function getRegistryDocumentNumber()
    {
        return $this->registryDocumentNumber;
    }
    /**
     * Set registryDocumentNumber value
     * @param string $registryDocumentNumber
     * @return \StructType\FssItemType
     */
    public function setRegistryDocumentNumber($registryDocumentNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($registryDocumentNumber) && strlen($registryDocumentNumber) > 9) || (is_array($registryDocumentNumber) && count($registryDocumentNumber) > 9)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s) at most, "%d" length given', is_scalar($registryDocumentNumber) ? strlen($registryDocumentNumber) : count($registryDocumentNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($registryDocumentNumber) && strlen($registryDocumentNumber) < 1) || (is_array($registryDocumentNumber) && count($registryDocumentNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($registryDocumentNumber) && !preg_match('/[A-Z0-9\\.]*/', $registryDocumentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.]*", "%s" given', var_export($registryDocumentNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registryDocumentNumber) && !is_string($registryDocumentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registryDocumentNumber)), __LINE__);
        }
        $this->registryDocumentNumber = $registryDocumentNumber;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\FssItemType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($amount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $amount), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $amount), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\FssItemType
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($taxAmount) && strlen(substr($taxAmount, strpos($taxAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($taxAmount, strpos($taxAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($taxAmount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $taxAmount), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($taxAmount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $taxAmount), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get taxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param string $taxCode
     * @return \StructType\FssItemType
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($taxCode) && strlen($taxCode) > 3) || (is_array($taxCode) && count($taxCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($taxCode) ? strlen($taxCode) : count($taxCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCode)), __LINE__);
        }
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @uses \EnumType\Channel::valueIsValid()
     * @uses \EnumType\Channel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \StructType\FssItemType
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Channel::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channel, implode(', ', \EnumType\Channel::getValidValues())), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @uses \EnumType\Quantity::valueIsValid()
     * @uses \EnumType\Quantity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quantity
     * @return \StructType\FssItemType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Quantity::valueIsValid($quantity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $quantity, implode(', ', \EnumType\Quantity::getValidValues())), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get suffix value
     * @return string|null
     */
    public function getSuffix()
    {
        return $this->suffix;
    }
    /**
     * Set suffix value
     * @param string $suffix
     * @return \StructType\FssItemType
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($suffix) && strlen($suffix) > 60) || (is_array($suffix) && count($suffix) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($suffix) ? strlen($suffix) : count($suffix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suffix)), __LINE__);
        }
        $this->suffix = $suffix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FssItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
