<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fssCustomerType StructType
 * @subpackage Structs
 */
class FssCustomerType extends AbstractStructBase
{
    /**
     * The account
     * @var \StructType\FssAccountType
     */
    public $account;
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * The person
     * @var \StructType\PersonNameType
     */
    public $person;
    /**
     * The organisationName
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $organisationName;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Holder name or business name, according with roleCategory value in filter element | composite person name or organisation name
     * - maxLength: 200
     * - minLength: 1
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $name;
    /**
     * The correspondenceName
     * Meta informations extracted from the WSDL
     * - documentation: Shortened name for letter windows
     * - maxLength: 40
     * @var string
     */
    public $correspondenceName;
    /**
     * The dateRegistration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRegistration;
    /**
     * The dateRenewalReview
     * Meta informations extracted from the WSDL
     * - documentation: Business Name Renewal Date or Company Review Date
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRenewalReview;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: DRGD DeregisteredPEND Pending PaymentREGD RegisteredRJCT Rejected ...
     * - maxLength: 4
     * @var string
     */
    public $status;
    /**
     * The phoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TelephoneNumberType
     */
    public $phoneNumber;
    /**
     * The faxNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TelephoneNumberType
     */
    public $faxNumber;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: email address
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * The agent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Agent
     */
    public $agent;
    /**
     * The creditLimit
     * Meta informations extracted from the WSDL
     * - documentation: 0 if ommitted | Special unsigned format for Qsp/PandD N15.2
     * - minOccurs: 0
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $creditLimit;
    /**
     * The billingAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingAddress
     */
    public $billingAddress;
    /**
     * Constructor method for fssCustomerType
     * @uses FssCustomerType::setAccount()
     * @uses FssCustomerType::setAbn()
     * @uses FssCustomerType::setPerson()
     * @uses FssCustomerType::setOrganisationName()
     * @uses FssCustomerType::setName()
     * @uses FssCustomerType::setCorrespondenceName()
     * @uses FssCustomerType::setDateRegistration()
     * @uses FssCustomerType::setDateRenewalReview()
     * @uses FssCustomerType::setStatus()
     * @uses FssCustomerType::setPhoneNumber()
     * @uses FssCustomerType::setFaxNumber()
     * @uses FssCustomerType::setEmailAddress()
     * @uses FssCustomerType::setAgent()
     * @uses FssCustomerType::setCreditLimit()
     * @uses FssCustomerType::setBillingAddress()
     * @param \StructType\FssAccountType $account
     * @param string $abn
     * @param \StructType\PersonNameType $person
     * @param string $organisationName
     * @param string $name
     * @param string $correspondenceName
     * @param string $dateRegistration
     * @param string $dateRenewalReview
     * @param string $status
     * @param \StructType\TelephoneNumberType $phoneNumber
     * @param \StructType\TelephoneNumberType $faxNumber
     * @param string $emailAddress
     * @param \StructType\Agent $agent
     * @param float $creditLimit
     * @param \StructType\BillingAddress $billingAddress
     */
    public function __construct(\StructType\FssAccountType $account = null, $abn = null, \StructType\PersonNameType $person = null, $organisationName = null, $name = null, $correspondenceName = null, $dateRegistration = null, $dateRenewalReview = null, $status = null, \StructType\TelephoneNumberType $phoneNumber = null, \StructType\TelephoneNumberType $faxNumber = null, $emailAddress = null, \StructType\Agent $agent = null, $creditLimit = null, \StructType\BillingAddress $billingAddress = null)
    {
        $this
            ->setAccount($account)
            ->setAbn($abn)
            ->setPerson($person)
            ->setOrganisationName($organisationName)
            ->setName($name)
            ->setCorrespondenceName($correspondenceName)
            ->setDateRegistration($dateRegistration)
            ->setDateRenewalReview($dateRenewalReview)
            ->setStatus($status)
            ->setPhoneNumber($phoneNumber)
            ->setFaxNumber($faxNumber)
            ->setEmailAddress($emailAddress)
            ->setAgent($agent)
            ->setCreditLimit($creditLimit)
            ->setBillingAddress($billingAddress);
    }
    /**
     * Get account value
     * @return \StructType\FssAccountType|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\FssAccountType $account
     * @return \StructType\FssCustomerType
     */
    public function setAccount(\StructType\FssAccountType $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\FssCustomerType
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get person value
     * @return \StructType\PersonNameType|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @param \StructType\PersonNameType $person
     * @return \StructType\FssCustomerType
     */
    public function setPerson(\StructType\PersonNameType $person = null)
    {
        $this->person = $person;
        return $this;
    }
    /**
     * Get organisationName value
     * @return string|null
     */
    public function getOrganisationName()
    {
        return $this->organisationName;
    }
    /**
     * Set organisationName value
     * @param string $organisationName
     * @return \StructType\FssCustomerType
     */
    public function setOrganisationName($organisationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organisationName) && strlen($organisationName) > 200) || (is_array($organisationName) && count($organisationName) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($organisationName) ? strlen($organisationName) : count($organisationName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organisationName) && !is_string($organisationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationName)), __LINE__);
        }
        $this->organisationName = $organisationName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\FssCustomerType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($name) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($name, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get correspondenceName value
     * @return string|null
     */
    public function getCorrespondenceName()
    {
        return $this->correspondenceName;
    }
    /**
     * Set correspondenceName value
     * @param string $correspondenceName
     * @return \StructType\FssCustomerType
     */
    public function setCorrespondenceName($correspondenceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($correspondenceName) && strlen($correspondenceName) > 40) || (is_array($correspondenceName) && count($correspondenceName) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($correspondenceName) ? strlen($correspondenceName) : count($correspondenceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($correspondenceName) && !is_string($correspondenceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($correspondenceName)), __LINE__);
        }
        $this->correspondenceName = $correspondenceName;
        return $this;
    }
    /**
     * Get dateRegistration value
     * @return string|null
     */
    public function getDateRegistration()
    {
        return $this->dateRegistration;
    }
    /**
     * Set dateRegistration value
     * @param string $dateRegistration
     * @return \StructType\FssCustomerType
     */
    public function setDateRegistration($dateRegistration = null)
    {
        // validation for constraint: minInclusive
        if ($dateRegistration < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRegistration), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRegistration) && !is_string($dateRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRegistration)), __LINE__);
        }
        $this->dateRegistration = $dateRegistration;
        return $this;
    }
    /**
     * Get dateRenewalReview value
     * @return string|null
     */
    public function getDateRenewalReview()
    {
        return $this->dateRenewalReview;
    }
    /**
     * Set dateRenewalReview value
     * @param string $dateRenewalReview
     * @return \StructType\FssCustomerType
     */
    public function setDateRenewalReview($dateRenewalReview = null)
    {
        // validation for constraint: minInclusive
        if ($dateRenewalReview < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRenewalReview), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRenewalReview) && !is_string($dateRenewalReview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRenewalReview)), __LINE__);
        }
        $this->dateRenewalReview = $dateRenewalReview;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\FssCustomerType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($status) && strlen($status) > 4) || (is_array($status) && count($status) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($status) ? strlen($status) : count($status)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return \StructType\TelephoneNumberType|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param \StructType\TelephoneNumberType $phoneNumber
     * @return \StructType\FssCustomerType
     */
    public function setPhoneNumber(\StructType\TelephoneNumberType $phoneNumber = null)
    {
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get faxNumber value
     * @return \StructType\TelephoneNumberType|null
     */
    public function getFaxNumber()
    {
        return $this->faxNumber;
    }
    /**
     * Set faxNumber value
     * @param \StructType\TelephoneNumberType $faxNumber
     * @return \StructType\FssCustomerType
     */
    public function setFaxNumber(\StructType\TelephoneNumberType $faxNumber = null)
    {
        $this->faxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \StructType\FssCustomerType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get agent value
     * @return \StructType\Agent|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \StructType\Agent $agent
     * @return \StructType\FssCustomerType
     */
    public function setAgent(\StructType\Agent $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get creditLimit value
     * @return float|null
     */
    public function getCreditLimit()
    {
        return $this->creditLimit;
    }
    /**
     * Set creditLimit value
     * @param float $creditLimit
     * @return \StructType\FssCustomerType
     */
    public function setCreditLimit($creditLimit = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($creditLimit) && strlen(substr($creditLimit, strpos($creditLimit, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($creditLimit, strpos($creditLimit, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($creditLimit > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $creditLimit), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($creditLimit < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $creditLimit), __LINE__);
        }
        $this->creditLimit = $creditLimit;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\BillingAddress|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\BillingAddress $billingAddress
     * @return \StructType\FssCustomerType
     */
    public function setBillingAddress(\StructType\BillingAddress $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FssCustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
