<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for feeWithAmountType StructType
 * @subpackage Structs
 */
class FeeWithAmountType extends AbstractStructBase
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The subType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $subType;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for feeWithAmountType
     * @uses FeeWithAmountType::setType()
     * @uses FeeWithAmountType::setSubType()
     * @uses FeeWithAmountType::setDescription()
     * @uses FeeWithAmountType::setAmount()
     * @param string $type
     * @param string $subType
     * @param string $description
     * @param float $amount
     */
    public function __construct($type = null, $subType = null, $description = null, $amount = null)
    {
        $this
            ->setType($type)
            ->setSubType($subType)
            ->setDescription($description)
            ->setAmount($amount);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\FeeWithAmountType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get subType value
     * @return string|null
     */
    public function getSubType()
    {
        return $this->subType;
    }
    /**
     * Set subType value
     * @param string $subType
     * @return \StructType\FeeWithAmountType
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subType) && strlen($subType) > 2) || (is_array($subType) && count($subType) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($subType) ? strlen($subType) : count($subType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subType) && !is_string($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subType)), __LINE__);
        }
        $this->subType = $subType;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\FeeWithAmountType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 60) || (is_array($description) && count($description) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\FeeWithAmountType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($amount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $amount), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $amount), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeeWithAmountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
