<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for exceptionType StructType
 * @subpackage Structs
 */
class ExceptionType extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The severity
     * @var string
     */
    public $severity;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The userDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 250
     * @var string
     */
    public $userDescription;
    /**
     * The context
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Context
     */
    public $context;
    /**
     * The nodeXPath
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $nodeXPath;
    /**
     * Constructor method for exceptionType
     * @uses ExceptionType::setCode()
     * @uses ExceptionType::setSeverity()
     * @uses ExceptionType::setDescription()
     * @uses ExceptionType::setUserDescription()
     * @uses ExceptionType::setContext()
     * @uses ExceptionType::setNodeXPath()
     * @param string $code
     * @param string $severity
     * @param string $description
     * @param string $userDescription
     * @param \StructType\Context $context
     * @param string $nodeXPath
     */
    public function __construct($code = null, $severity = null, $description = null, $userDescription = null, \StructType\Context $context = null, $nodeXPath = null)
    {
        $this
            ->setCode($code)
            ->setSeverity($severity)
            ->setDescription($description)
            ->setUserDescription($userDescription)
            ->setContext($context)
            ->setNodeXPath($nodeXPath);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @uses \EnumType\Code::valueIsValid()
     * @uses \EnumType\Code::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\ExceptionType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Code::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \EnumType\Code::getValidValues())), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->severity;
    }
    /**
     * Set severity value
     * @uses \EnumType\Severity::valueIsValid()
     * @uses \EnumType\Severity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $severity
     * @return \StructType\ExceptionType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Severity::valueIsValid($severity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $severity, implode(', ', \EnumType\Severity::getValidValues())), __LINE__);
        }
        $this->severity = $severity;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ExceptionType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 60) || (is_array($description) && count($description) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get userDescription value
     * @return string|null
     */
    public function getUserDescription()
    {
        return $this->userDescription;
    }
    /**
     * Set userDescription value
     * @param string $userDescription
     * @return \StructType\ExceptionType
     */
    public function setUserDescription($userDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userDescription) && strlen($userDescription) > 250) || (is_array($userDescription) && count($userDescription) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($userDescription) ? strlen($userDescription) : count($userDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userDescription) && !is_string($userDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userDescription)), __LINE__);
        }
        $this->userDescription = $userDescription;
        return $this;
    }
    /**
     * Get context value
     * @return \StructType\Context|null
     */
    public function getContext()
    {
        return $this->context;
    }
    /**
     * Set context value
     * @param \StructType\Context $context
     * @return \StructType\ExceptionType
     */
    public function setContext(\StructType\Context $context = null)
    {
        $this->context = $context;
        return $this;
    }
    /**
     * Get nodeXPath value
     * @return string|null
     */
    public function getNodeXPath()
    {
        return $this->nodeXPath;
    }
    /**
     * Set nodeXPath value
     * @param string $nodeXPath
     * @return \StructType\ExceptionType
     */
    public function setNodeXPath($nodeXPath = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nodeXPath) && strlen($nodeXPath) > 200) || (is_array($nodeXPath) && count($nodeXPath) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($nodeXPath) ? strlen($nodeXPath) : count($nodeXPath)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nodeXPath) && !is_string($nodeXPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nodeXPath)), __LINE__);
        }
        $this->nodeXPath = $nodeXPath;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExceptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
