<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for documentType StructType
 * Meta informations extracted from the WSDL
 * - maxLength: 50
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - documentation: Ascot document number
     * - maxLength: 9
     * - minLength: 1
     * - pattern: [A-Z0-9\.]*
     * @var string
     */
    public $documentNumber;
    /**
     * The dateReceived
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateReceived;
    /**
     * The formCode
     * Meta informations extracted from the WSDL
     * - maxLength: 5
     * @var string
     */
    public $formCode;
    /**
     * The numberOfPages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 9999
     * @var int
     */
    public $numberOfPages;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxLength: 80
     * @var string
     */
    public $description;
    /**
     * The additionalDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\AdditionalDescription[]
     */
    public $additionalDescription;
    /**
     * Constructor method for documentType
     * @uses DocumentType::setDocumentNumber()
     * @uses DocumentType::setDateReceived()
     * @uses DocumentType::setFormCode()
     * @uses DocumentType::setNumberOfPages()
     * @uses DocumentType::setDescription()
     * @uses DocumentType::setAdditionalDescription()
     * @param string $documentNumber
     * @param string $dateReceived
     * @param string $formCode
     * @param int $numberOfPages
     * @param string $description
     * @param \StructType\AdditionalDescription[] $additionalDescription
     */
    public function __construct($documentNumber = null, $dateReceived = null, $formCode = null, $numberOfPages = null, $description = null, array $additionalDescription = array())
    {
        $this
            ->setDocumentNumber($documentNumber)
            ->setDateReceived($dateReceived)
            ->setFormCode($formCode)
            ->setNumberOfPages($numberOfPages)
            ->setDescription($description)
            ->setAdditionalDescription($additionalDescription);
    }
    /**
     * Get documentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param string $documentNumber
     * @return \StructType\DocumentType
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) > 9) || (is_array($documentNumber) && count($documentNumber) > 9)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s) at most, "%d" length given', is_scalar($documentNumber) ? strlen($documentNumber) : count($documentNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) < 1) || (is_array($documentNumber) && count($documentNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($documentNumber) && !preg_match('/[A-Z0-9\\.]*/', $documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.]*", "%s" given', var_export($documentNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get dateReceived value
     * @return string|null
     */
    public function getDateReceived()
    {
        return $this->dateReceived;
    }
    /**
     * Set dateReceived value
     * @param string $dateReceived
     * @return \StructType\DocumentType
     */
    public function setDateReceived($dateReceived = null)
    {
        // validation for constraint: minInclusive
        if ($dateReceived < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateReceived), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateReceived) && !is_string($dateReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateReceived)), __LINE__);
        }
        $this->dateReceived = $dateReceived;
        return $this;
    }
    /**
     * Get formCode value
     * @return string|null
     */
    public function getFormCode()
    {
        return $this->formCode;
    }
    /**
     * Set formCode value
     * @param string $formCode
     * @return \StructType\DocumentType
     */
    public function setFormCode($formCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($formCode) && strlen($formCode) > 5) || (is_array($formCode) && count($formCode) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($formCode) ? strlen($formCode) : count($formCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($formCode) && !is_string($formCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formCode)), __LINE__);
        }
        $this->formCode = $formCode;
        return $this;
    }
    /**
     * Get numberOfPages value
     * @return int|null
     */
    public function getNumberOfPages()
    {
        return $this->numberOfPages;
    }
    /**
     * Set numberOfPages value
     * @param int $numberOfPages
     * @return \StructType\DocumentType
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: maxInclusive
        if ($numberOfPages > 9999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999, "%s" given', $numberOfPages), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($numberOfPages) && !is_numeric($numberOfPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfPages)), __LINE__);
        }
        $this->numberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DocumentType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 80) || (is_array($description) && count($description) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get additionalDescription value
     * @return \StructType\AdditionalDescription[]|null
     */
    public function getAdditionalDescription()
    {
        return $this->additionalDescription;
    }
    /**
     * Set additionalDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalDescription[] $additionalDescription
     * @return \StructType\DocumentType
     */
    public function setAdditionalDescription(array $additionalDescription = array())
    {
        foreach ($additionalDescription as $documentTypeAdditionalDescriptionItem) {
            // validation for constraint: itemType
            if (!$documentTypeAdditionalDescriptionItem instanceof \StructType\AdditionalDescription) {
                throw new \InvalidArgumentException(sprintf('The additionalDescription property can only contain items of \StructType\AdditionalDescription, "%s" given', is_object($documentTypeAdditionalDescriptionItem) ? get_class($documentTypeAdditionalDescriptionItem) : gettype($documentTypeAdditionalDescriptionItem)), __LINE__);
            }
        }
        $this->additionalDescription = $additionalDescription;
        return $this;
    }
    /**
     * Add item to additionalDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalDescription $item
     * @return \StructType\DocumentType
     */
    public function addToAdditionalDescription(\StructType\AdditionalDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalDescription) {
            throw new \InvalidArgumentException(sprintf('The additionalDescription property can only contain items of \StructType\AdditionalDescription, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->additionalDescription[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
