<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for distinguishedNameType StructType
 * @subpackage Structs
 */
class DistinguishedNameType extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $name;
    /**
     * The distinguishedWord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 140
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $distinguishedWord;
    /**
     * Constructor method for distinguishedNameType
     * @uses DistinguishedNameType::setName()
     * @uses DistinguishedNameType::setDistinguishedWord()
     * @param string $name
     * @param string $distinguishedWord
     */
    public function __construct($name = null, $distinguishedWord = null)
    {
        $this
            ->setName($name)
            ->setDistinguishedWord($distinguishedWord);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DistinguishedNameType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get distinguishedWord value
     * @return string|null
     */
    public function getDistinguishedWord()
    {
        return $this->distinguishedWord;
    }
    /**
     * Set distinguishedWord value
     * @param string $distinguishedWord
     * @return \StructType\DistinguishedNameType
     */
    public function setDistinguishedWord($distinguishedWord = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($distinguishedWord) && strlen($distinguishedWord) > 140) || (is_array($distinguishedWord) && count($distinguishedWord) > 140)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 140 element(s) or a scalar of 140 character(s) at most, "%d" length given', is_scalar($distinguishedWord) ? strlen($distinguishedWord) : count($distinguishedWord)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($distinguishedWord) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $distinguishedWord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($distinguishedWord, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($distinguishedWord) && !is_string($distinguishedWord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distinguishedWord)), __LINE__);
        }
        $this->distinguishedWord = $distinguishedWord;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistinguishedNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
