<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for creditCardType StructType
 * @subpackage Structs
 */
class CreditCardType extends AbstractStructBase
{
    /**
     * The brand
     * @var string
     */
    public $brand;
    /**
     * The encrypted
     * Meta informations extracted from the WSDL
     * - maxLength: 256
     * @var string
     */
    public $encrypted;
    /**
     * Constructor method for creditCardType
     * @uses CreditCardType::setBrand()
     * @uses CreditCardType::setEncrypted()
     * @param string $brand
     * @param string $encrypted
     */
    public function __construct($brand = null, $encrypted = null)
    {
        $this
            ->setBrand($brand)
            ->setEncrypted($encrypted);
    }
    /**
     * Get brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->brand;
    }
    /**
     * Set brand value
     * @uses \EnumType\Brand::valueIsValid()
     * @uses \EnumType\Brand::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $brand
     * @return \StructType\CreditCardType
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Brand::valueIsValid($brand)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $brand, implode(', ', \EnumType\Brand::getValidValues())), __LINE__);
        }
        $this->brand = $brand;
        return $this;
    }
    /**
     * Get encrypted value
     * @return string|null
     */
    public function getEncrypted()
    {
        return $this->encrypted;
    }
    /**
     * Set encrypted value
     * @param string $encrypted
     * @return \StructType\CreditCardType
     */
    public function setEncrypted($encrypted = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($encrypted) && strlen($encrypted) > 256) || (is_array($encrypted) && count($encrypted) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($encrypted) ? strlen($encrypted) : count($encrypted)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($encrypted) && !is_string($encrypted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encrypted)), __LINE__);
        }
        $this->encrypted = $encrypted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
