<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for context StructType
 * @subpackage Structs
 */
class Context extends AbstractStructBase
{
    /**
     * The line
     * Meta informations extracted from the WSDL
     * - maxOccurs: 20
     * - documentation: Text - will add basic formatting here
     * - maxLength: 250
     * - pattern: [a-zA-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string[]
     */
    public $line;
    /**
     * Constructor method for context
     * @uses Context::setLine()
     * @param string[] $line
     */
    public function __construct(array $line = array())
    {
        $this
            ->setLine($line);
    }
    /**
     * Get line value
     * @return string[]|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @throws \InvalidArgumentException
     * @param string[] $line
     * @return \StructType\Context
     */
    public function setLine(array $line = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($line) && strlen($line) > 250) || (is_array($line) && count($line) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($line) ? strlen($line) : count($line)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($line) && !preg_match('/[a-zA-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-zA-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($line, true)), __LINE__);
        }
        foreach ($line as $contextLineItem) {
            // validation for constraint: itemType
            if (!is_string($contextLineItem)) {
                throw new \InvalidArgumentException(sprintf('The line property can only contain items of string, "%s" given', is_object($contextLineItem) ? get_class($contextLineItem) : gettype($contextLineItem)), __LINE__);
            }
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Add item to line value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Context
     */
    public function addToLine($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 250) || (is_array($item) && count($item) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[a-zA-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-zA-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The line property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->line[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Context
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
