<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for companySignatoryType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Document signatory
 * @subpackage Structs
 */
class CompanySignatoryType extends AbstractStructBase
{
    /**
     * The name
     * @var \StructType\PersonNameLodgeType
     */
    public $name;
    /**
     * The capacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $capacity;
    /**
     * The dateSigned
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateSigned;
    /**
     * The declaresTrueAndCorrect
     * Meta informations extracted from the WSDL
     * - pattern: true
     * @var bool
     */
    public $declaresTrueAndCorrect;
    /**
     * Constructor method for companySignatoryType
     * @uses CompanySignatoryType::setName()
     * @uses CompanySignatoryType::setCapacity()
     * @uses CompanySignatoryType::setDateSigned()
     * @uses CompanySignatoryType::setDeclaresTrueAndCorrect()
     * @param \StructType\PersonNameLodgeType $name
     * @param string $capacity
     * @param string $dateSigned
     * @param bool $declaresTrueAndCorrect
     */
    public function __construct(\StructType\PersonNameLodgeType $name = null, $capacity = null, $dateSigned = null, $declaresTrueAndCorrect = null)
    {
        $this
            ->setName($name)
            ->setCapacity($capacity)
            ->setDateSigned($dateSigned)
            ->setDeclaresTrueAndCorrect($declaresTrueAndCorrect);
    }
    /**
     * Get name value
     * @return \StructType\PersonNameLodgeType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\PersonNameLodgeType $name
     * @return \StructType\CompanySignatoryType
     */
    public function setName(\StructType\PersonNameLodgeType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get capacity value
     * @return string|null
     */
    public function getCapacity()
    {
        return $this->capacity;
    }
    /**
     * Set capacity value
     * @uses \EnumType\Capacity::valueIsValid()
     * @uses \EnumType\Capacity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $capacity
     * @return \StructType\CompanySignatoryType
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Capacity::valueIsValid($capacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $capacity, implode(', ', \EnumType\Capacity::getValidValues())), __LINE__);
        }
        $this->capacity = $capacity;
        return $this;
    }
    /**
     * Get dateSigned value
     * @return string|null
     */
    public function getDateSigned()
    {
        return $this->dateSigned;
    }
    /**
     * Set dateSigned value
     * @param string $dateSigned
     * @return \StructType\CompanySignatoryType
     */
    public function setDateSigned($dateSigned = null)
    {
        // validation for constraint: minInclusive
        if ($dateSigned < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateSigned), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateSigned) && !is_string($dateSigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateSigned)), __LINE__);
        }
        $this->dateSigned = $dateSigned;
        return $this;
    }
    /**
     * Get declaresTrueAndCorrect value
     * @return bool|null
     */
    public function getDeclaresTrueAndCorrect()
    {
        return $this->declaresTrueAndCorrect;
    }
    /**
     * Set declaresTrueAndCorrect value
     * @param bool $declaresTrueAndCorrect
     * @return \StructType\CompanySignatoryType
     */
    public function setDeclaresTrueAndCorrect($declaresTrueAndCorrect = null)
    {
        // validation for constraint: pattern
        if (is_scalar($declaresTrueAndCorrect) && !preg_match('/true/', $declaresTrueAndCorrect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($declaresTrueAndCorrect, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($declaresTrueAndCorrect) && !is_bool($declaresTrueAndCorrect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($declaresTrueAndCorrect)), __LINE__);
        }
        $this->declaresTrueAndCorrect = $declaresTrueAndCorrect;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanySignatoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
