<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for companyExtractRequestType StructType
 * @subpackage Structs
 */
class CompanyExtractRequestType extends AbstractStructBase
{
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - documentation: ABN as 99999999999 | ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * The acn
     * Meta informations extracted from the WSDL
     * - documentation: ACN CompanyARBN Australian Registered BodyARSN Australian Registered Scheme
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $acn;
    /**
     * The company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Company
     */
    public $company;
    /**
     * The formerNames
     * Meta informations extracted from the WSDL
     * - documentation: if set returns Former Names of organisastion
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $formerNames;
    /**
     * The businessNames
     * Meta informations extracted from the WSDL
     * - documentation: if set returns Business Names owned by organisastion
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $businessNames;
    /**
     * The document
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Document
     */
    public $document;
    /**
     * Constructor method for companyExtractRequestType
     * @uses CompanyExtractRequestType::setAbn()
     * @uses CompanyExtractRequestType::setAcn()
     * @uses CompanyExtractRequestType::setCompany()
     * @uses CompanyExtractRequestType::setFormerNames()
     * @uses CompanyExtractRequestType::setBusinessNames()
     * @uses CompanyExtractRequestType::setDocument()
     * @param string $abn
     * @param int $acn
     * @param \StructType\Company $company
     * @param bool $formerNames
     * @param bool $businessNames
     * @param \StructType\Document $document
     */
    public function __construct($abn = null, $acn = null, \StructType\Company $company = null, $formerNames = null, $businessNames = null, \StructType\Document $document = null)
    {
        $this
            ->setAbn($abn)
            ->setAcn($acn)
            ->setCompany($company)
            ->setFormerNames($formerNames)
            ->setBusinessNames($businessNames)
            ->setDocument($document);
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\CompanyExtractRequestType
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get acn value
     * @return int|null
     */
    public function getAcn()
    {
        return $this->acn;
    }
    /**
     * Set acn value
     * @param int $acn
     * @return \StructType\CompanyExtractRequestType
     */
    public function setAcn($acn = null)
    {
        // validation for constraint: maxInclusive
        if ($acn > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $acn), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($acn < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $acn), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($acn) && !is_numeric($acn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($acn)), __LINE__);
        }
        $this->acn = $acn;
        return $this;
    }
    /**
     * Get company value
     * @return \StructType\Company|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param \StructType\Company $company
     * @return \StructType\CompanyExtractRequestType
     */
    public function setCompany(\StructType\Company $company = null)
    {
        $this->company = $company;
        return $this;
    }
    /**
     * Get formerNames value
     * @return bool|null
     */
    public function getFormerNames()
    {
        return $this->formerNames;
    }
    /**
     * Set formerNames value
     * @param bool $formerNames
     * @return \StructType\CompanyExtractRequestType
     */
    public function setFormerNames($formerNames = null)
    {
        // validation for constraint: pattern
        if (is_scalar($formerNames) && !preg_match('/true/', $formerNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($formerNames, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($formerNames) && !is_bool($formerNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($formerNames)), __LINE__);
        }
        $this->formerNames = $formerNames;
        return $this;
    }
    /**
     * Get businessNames value
     * @return bool|null
     */
    public function getBusinessNames()
    {
        return $this->businessNames;
    }
    /**
     * Set businessNames value
     * @param bool $businessNames
     * @return \StructType\CompanyExtractRequestType
     */
    public function setBusinessNames($businessNames = null)
    {
        // validation for constraint: pattern
        if (is_scalar($businessNames) && !preg_match('/true/', $businessNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($businessNames, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($businessNames) && !is_bool($businessNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($businessNames)), __LINE__);
        }
        $this->businessNames = $businessNames;
        return $this;
    }
    /**
     * Get document value
     * @return \StructType\Document|null
     */
    public function getDocument()
    {
        return $this->document;
    }
    /**
     * Set document value
     * @param \StructType\Document $document
     * @return \StructType\CompanyExtractRequestType
     */
    public function setDocument(\StructType\Document $document = null)
    {
        $this->document = $document;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyExtractRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
